/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.rexster.conf.GiraphRexsterConstants;
import org.apache.giraph.rexster.io.RexsterInputSplit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class RexsterUtils {
    public static final char KEY_VALUE_SEPARATOR = ':';
    public static final char START_OBJECT = '{';
    public static final char END_OBJECT = '}';
    public static final char START_ARRAY = '[';
    public static final char END_ARRAY = ']';
    public static final char ARRAY_SEPARATOR = ',';
    private static final Logger LOG = Logger.getLogger(RexsterUtils.class);

    private RexsterUtils() {
    }

    public static JSONTokener parseJSONEnvelope(BufferedReader br) throws InterruptedException {
        JSONTokener tokener = null;
        try {
            tokener = new JSONTokener((Reader)br);
            if (tokener.nextClean() != '{') {
                LOG.error((Object)String.format("A JSONObject text must begin with '%c'", Character.valueOf('{')));
            }
            char c = '\u0000';
            String key = null;
            block10: while (true) {
                c = tokener.nextClean();
                switch (c) {
                    case '\u0000': {
                        LOG.error((Object)String.format("A JSONObject text must end with '%c'", Character.valueOf('}')));
                        break;
                    }
                    case '}': {
                        return tokener;
                    }
                    default: {
                        tokener.back();
                        key = tokener.nextValue().toString();
                    }
                }
                c = tokener.nextClean();
                if (c != ':') {
                    LOG.error((Object)String.format("Expected a %c after a key", Character.valueOf(c)));
                }
                if (key == null || key.equals("results")) {
                    c = tokener.nextClean();
                    if (c != '[') {
                        LOG.error((Object)"'results' is expected to be an array");
                    }
                    if ((c = tokener.nextClean()) == ']') {
                        return null;
                    }
                    tokener.back();
                    return tokener;
                }
                tokener.nextValue();
                switch (tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == '}') {
                            return tokener;
                        }
                        tokener.back();
                        continue block10;
                    }
                    case '}': {
                        return tokener;
                    }
                }
                LOG.error((Object)"Expected a ',' or '}'");
            }
        }
        catch (JSONException e) {
            LOG.error((Object)("Unable to parse the JSON with the vertices.\n" + e.getMessage()));
            throw new InterruptedException(e.toString());
        }
    }

    public static List<InputSplit> getSplits(JobContext context, long estimation) throws IOException, InterruptedException {
        int chunks = context.getConfiguration().getInt("mapred.map.tasks", 1);
        long chunkSize = estimation / (long)chunks;
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Estimated objects: %d", estimation));
            LOG.debug((Object)String.format("Number of chunks: %d", chunks));
        }
        for (int i = 0; i < chunks; ++i) {
            long start = (long)i * chunkSize;
            long end = i + 1 == chunks ? Long.MAX_VALUE : (long)i * chunkSize + chunkSize;
            RexsterInputSplit split = new RexsterInputSplit(start, end);
            splits.add(split);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)String.format("Chunk: start %d; end %d;", start, end));
            LOG.debug((Object)String.format("Chunk: size %d;", chunkSize));
            LOG.debug((Object)split);
        }
        return splits;
    }

    public static BufferedReader openInputStream(ImmutableClassesGiraphConfiguration conf, long start, long end, String type, String gremlinScript) throws InterruptedException {
        String uriScriptFormat = "/graphs/%s/tp/gremlin?script=%s&rexster.offset.start=%s&rexster.offset.end=%s";
        String uriFormat = "/graphs/%s/tp/giraph/%s/?rexster.offset.start=%s&rexster.offset.end=%s";
        String endpoint = GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.get((Configuration)conf);
        try {
            boolean isSsl = GiraphRexsterConstants.GIRAPH_REXSTER_USES_SSL.get((Configuration)conf);
            int port = GiraphRexsterConstants.GIRAPH_REXSTER_PORT.get((Configuration)conf);
            String graph = GiraphRexsterConstants.GIRAPH_REXSTER_INPUT_GRAPH.get((Configuration)conf);
            URL url = gremlinScript != null && !gremlinScript.isEmpty() ? new URL(isSsl ? "https" : "http", endpoint, port, String.format(uriScriptFormat, graph, gremlinScript, start, end)) : new URL(isSsl ? "https" : "http", endpoint, port, String.format(uriFormat, graph, type, start, end));
            LOG.info((Object)url);
            String username = GiraphRexsterConstants.GIRAPH_REXSTER_USERNAME.get((Configuration)conf);
            String password = GiraphRexsterConstants.GIRAPH_REXSTER_PASSWORD.get((Configuration)conf);
            String auth = RexsterUtils.getHTTPAuthString(username, password);
            HttpURLConnection connection = RexsterUtils.createConnection(url, "GET", auth);
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setDoInput(true);
            connection.setDoOutput(false);
            RexsterUtils.handleResponse(connection, type);
            InputStream is = connection.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
            return new BufferedReader(isr);
        }
        catch (Exception e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    public static HttpURLConnection openOutputConnection(ImmutableClassesGiraphConfiguration conf, String type) throws InterruptedException {
        String uriFormat = "/graphs/%s/tp/giraph/%s/";
        String endpoint = GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.get((Configuration)conf);
        boolean isSsl = GiraphRexsterConstants.GIRAPH_REXSTER_USES_SSL.get((Configuration)conf);
        int port = GiraphRexsterConstants.GIRAPH_REXSTER_PORT.get((Configuration)conf);
        String graph = GiraphRexsterConstants.GIRAPH_REXSTER_OUTPUT_GRAPH.get((Configuration)conf);
        try {
            URL url = new URL(isSsl ? "https" : "http", endpoint, port, String.format(uriFormat, graph, type));
            LOG.info((Object)url);
            String username = GiraphRexsterConstants.GIRAPH_REXSTER_USERNAME.get((Configuration)conf);
            String password = GiraphRexsterConstants.GIRAPH_REXSTER_PASSWORD.get((Configuration)conf);
            String auth = RexsterUtils.getHTTPAuthString(username, password);
            HttpURLConnection connection = RexsterUtils.createConnection(url, "POST", auth);
            connection.setRequestProperty("Content-Type", "application/json; cherset=UTF-8");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            return connection;
        }
        catch (Exception e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    private static HttpURLConnection createConnection(URL url, String method, String authValue) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(0);
        connection.setReadTimeout(0);
        connection.setRequestMethod(method);
        if (authValue != null) {
            connection.setRequestProperty("Authorization", authValue);
        }
        return connection;
    }

    private static void handleResponse(HttpURLConnection conn, String type) throws IOException, InterruptedException {
        if (conn.getResponseCode() != 200) {
            String aux;
            InputStream is = conn.getErrorStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            JSONObject obj = new JSONObject((Object)rd);
            StringBuffer sb = new StringBuffer("Error occured while saving " + type + ";");
            while ((aux = rd.readLine()) != null) {
                sb.append(aux);
            }
            sb.append(obj);
            rd.close();
            throw new InterruptedException(sb.toString());
        }
    }

    private static String getHTTPAuthString(String username, String password) {
        if (username.isEmpty()) {
            return null;
        }
        return "Basic " + Base64.encodeBase64URLSafeString((byte[])(username + ":" + password).getBytes(Charset.forName("UTF-8")));
    }

    public static class Edge {
        private Edge() {
        }

        public static BufferedReader openInputStream(ImmutableClassesGiraphConfiguration conf, long start, long end) throws InterruptedException {
            String gremlinScript = GiraphRexsterConstants.GIRAPH_REXSTER_GREMLIN_E_SCRIPT.get((Configuration)conf);
            return RexsterUtils.openInputStream(conf, start, end, "edges", gremlinScript);
        }

        public static HttpURLConnection openOutputConnection(ImmutableClassesGiraphConfiguration conf) throws InterruptedException {
            return RexsterUtils.openOutputConnection(conf, "edges");
        }

        public static void handleResponse(HttpURLConnection conn) throws IOException, InterruptedException {
            RexsterUtils.handleResponse(conn, "edges");
        }
    }

    public static class Vertex {
        private Vertex() {
        }

        public static BufferedReader openInputStream(ImmutableClassesGiraphConfiguration conf, long start, long end) throws InterruptedException {
            String gremlinScript = GiraphRexsterConstants.GIRAPH_REXSTER_GREMLIN_V_SCRIPT.get((Configuration)conf);
            return RexsterUtils.openInputStream(conf, start, end, "vertices", gremlinScript);
        }

        public static HttpURLConnection openOutputConnection(ImmutableClassesGiraphConfiguration conf) throws InterruptedException {
            return RexsterUtils.openOutputConnection(conf, "vertices");
        }

        public static void handleResponse(HttpURLConnection conn) throws IOException, InterruptedException {
            RexsterUtils.handleResponse(conn, "vertices");
        }
    }
}

