/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.io.formats;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.rexster.io.RexsterEdgeInputFormat;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.json.JSONException;
import org.json.JSONObject;

public class RexsterLongFloatEdgeInputFormat
extends RexsterEdgeInputFormat<LongWritable, FloatWritable> {
    @Override
    public RexsterEdgeInputFormat.RexsterEdgeReader createEdgeReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new RexsterLongFloatEdgeReader();
    }

    protected class RexsterLongFloatEdgeReader
    extends RexsterEdgeInputFormat.RexsterEdgeReader {
        private LongWritable sourceId;

        protected RexsterLongFloatEdgeReader() {
            super(RexsterLongFloatEdgeInputFormat.this);
        }

        public LongWritable getCurrentSourceId() throws IOException, InterruptedException {
            return this.sourceId;
        }

        protected Edge<LongWritable, FloatWritable> parseEdge(JSONObject jsonEdge) throws JSONException {
            Long sid;
            Long dest;
            Long value = jsonEdge.getLong("value");
            try {
                dest = jsonEdge.getLong("_outV");
            }
            catch (JSONException ex) {
                String idString = jsonEdge.getString("_outV");
                String[] splits = idString.split(":");
                dest = Long.parseLong(splits[1]);
            }
            Edge edge = EdgeFactory.create((WritableComparable)new LongWritable(dest.longValue()), (Writable)new FloatWritable((float)value.longValue()));
            try {
                sid = jsonEdge.getLong("_inV");
            }
            catch (JSONException ex) {
                String sidString = jsonEdge.getString("_inV");
                String[] splits = sidString.split(":");
                sid = Long.parseLong(splits[1]);
            }
            this.sourceId = new LongWritable(sid.longValue());
            return edge;
        }
    }
}

