/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.io.formats;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.rexster.io.RexsterEdgeOutputFormat;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.json.JSONException;
import org.json.JSONObject;

public class RexsterLongDoubleFloatEdgeOutputFormat
extends RexsterEdgeOutputFormat<LongWritable, DoubleWritable, FloatWritable> {
    @Override
    public RexsterEdgeOutputFormat.RexsterEdgeWriter createEdgeWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new RexsterLongDoubleFloatEdgeWriter();
    }

    protected class RexsterLongDoubleFloatEdgeWriter
    extends RexsterEdgeOutputFormat.RexsterEdgeWriter {
        protected RexsterLongDoubleFloatEdgeWriter() {
            super(RexsterLongDoubleFloatEdgeOutputFormat.this);
        }

        protected JSONObject getEdge(LongWritable srcId, DoubleWritable srcValue, Edge<LongWritable, FloatWritable> edge) throws JSONException {
            long outId = srcId.get();
            long inId = ((LongWritable)edge.getTargetVertexId()).get();
            float value = ((FloatWritable)edge.getValue()).get();
            JSONObject jsonEdge = new JSONObject();
            jsonEdge.accumulate("_outV", (Object)outId);
            jsonEdge.accumulate("_inV", (Object)inId);
            jsonEdge.accumulate("value", (Object)Float.valueOf(value));
            return jsonEdge;
        }
    }
}

