/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.io.formats;

import java.io.IOException;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.rexster.io.RexsterVertexInputFormat;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.json.JSONException;
import org.json.JSONObject;

public class RexsterLongDoubleDoubleVertexInputFormat
extends RexsterVertexInputFormat<LongWritable, DoubleWritable, DoubleWritable> {
    @Override
    public RexsterVertexInputFormat.RexsterVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new RexsterLongDoubleDoubleVertexReader();
    }

    protected class RexsterLongDoubleDoubleVertexReader
    extends RexsterVertexInputFormat.RexsterVertexReader {
        protected RexsterLongDoubleDoubleVertexReader() {
            super(RexsterLongDoubleDoubleVertexInputFormat.this);
        }

        protected Vertex<LongWritable, DoubleWritable, DoubleWritable> parseVertex(JSONObject jsonVertex) throws JSONException {
            Double value;
            Long id;
            Vertex vertex = this.getConf().createVertex();
            try {
                id = jsonVertex.getLong("_id");
            }
            catch (JSONException ex) {
                String idString = jsonVertex.getString("_id");
                String[] splits = idString.split(":");
                id = Long.parseLong(splits[1]);
            }
            try {
                value = jsonVertex.getDouble("value");
            }
            catch (JSONException ex) {
                value = new Double(0.0);
            }
            vertex.initialize((WritableComparable)new LongWritable(id.longValue()), (Writable)new DoubleWritable(value.doubleValue()));
            return vertex;
        }
    }
}

