/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.rexster.conf.GiraphRexsterConstants;
import org.apache.giraph.rexster.utils.RexsterUtils;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.giraph.zk.ZooKeeperManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.json.JSONException;
import org.json.JSONObject;

public class RexsterVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    private static final Logger LOG = Logger.getLogger(RexsterVertexOutputFormat.class);

    public RexsterVertexWriter createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new RexsterVertexWriter();
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        GiraphConfiguration gconf = new GiraphConfiguration(context.getConfiguration());
        String msg = "Rexster OutputFormat usage requires both Edge and Vertex OutputFormat's.";
        if (!gconf.hasEdgeOutputFormat()) {
            LOG.error((Object)msg);
            throw new InterruptedException(msg);
        }
        String endpoint = GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.get((Configuration)gconf);
        if (endpoint == null) {
            throw new InterruptedException(GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.getKey() + " is a mandatory parameter.");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    protected class RexsterVertexWriter
    extends VertexWriter<I, V, E>
    implements Watcher {
        private static final String BARRIER_PATH = "/_rexsterBarrier";
        private static final String JSON_ARRAY_KEY = "tx";
        private HttpURLConnection rexsterConn;
        private BufferedWriter rexsterBufferedStream;
        private boolean isFirstElement = true;
        private ZooKeeperExt zk = null;
        private final Object lock = new Object();
        private int txsize;
        private int txcounter = 0;
        private String vlabel;
        private I vertexId;

        protected RexsterVertexWriter() {
        }

        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            ImmutableClassesGiraphConfiguration conf = this.getConf();
            this.vlabel = GiraphRexsterConstants.GIRAPH_REXSTER_VLABEL.get((Configuration)conf);
            this.txsize = GiraphRexsterConstants.GIRAPH_REXSTER_OUTPUT_V_TXSIZE.get((Configuration)conf);
            this.startConnection();
            this.zk = new ZooKeeperExt(conf.getZookeeperList(), conf.getZooKeeperSessionTimeout(), conf.getZookeeperOpsMaxAttempts(), conf.getZookeeperOpsRetryWaitMsecs(), (Watcher)this, (Progressable)context);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.stopConnection();
            String id = context.getTaskAttemptID().toString();
            String zkBasePath = ZooKeeperManager.getBasePath((Configuration)this.getConf()) + "/_hadoopBsp" + "/" + this.getConf().get("mapred.job.id", "Unknown Job");
            this.prepareBarrier(zkBasePath);
            this.enterBarrier(zkBasePath, id);
            this.checkBarrier(zkBasePath, context);
        }

        public void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
            if (this.txcounter == this.txsize) {
                this.txcounter = 0;
                this.isFirstElement = true;
                this.stopConnection();
                this.startConnection();
            }
            try {
                JSONObject jsonVertex = this.getVertex(vertex);
                jsonVertex.accumulate("_type", (Object)"vertex");
                jsonVertex.accumulate(this.vlabel, (Object)this.getVertexId().toString());
                String suffix = ",";
                if (this.isFirstElement) {
                    this.isFirstElement = false;
                    suffix = "";
                }
                this.rexsterBufferedStream.write(suffix + jsonVertex);
                ++this.txcounter;
            }
            catch (JSONException e) {
                throw new InterruptedException("Error writing the vertex: " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            Watcher.Event.EventType type = event.getType();
            if (type == Watcher.Event.EventType.NodeChildrenChanged) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"signal: number of children changed.");
                }
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
            }
        }

        private void prepareBarrier(String zkBasePath) throws InterruptedException {
            try {
                this.zk.createExt(zkBasePath + BARRIER_PATH, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
            }
            catch (KeeperException.NodeExistsException nee) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"rexster barrier znode already exists.");
                }
            }
            catch (KeeperException ke) {
                throw new InterruptedException("RexsterVertexOutputFormat: error while creating the barrier: " + ke.getMessage());
            }
        }

        private void enterBarrier(String zkBasePath, String id) throws InterruptedException {
            try {
                this.zk.createExt(zkBasePath + BARRIER_PATH + "/" + id, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, false);
            }
            catch (KeeperException.NodeExistsException nee) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"rexster barrier znode already exists.");
                }
            }
            catch (KeeperException ke) {
                throw new InterruptedException("RexsterVertexOutputFormat: error while creating the barrier: " + ke.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkBarrier(String zkBasePath, TaskAttemptContext context) throws InterruptedException {
            long workersNum = this.getConf().getMapTasks() - 1;
            int timeout = GiraphRexsterConstants.GIRAPH_REXSTER_OUTPUT_WAIT_TIMEOUT.get((Configuration)this.getConf());
            try {
                List list;
                String barrierPath = zkBasePath + BARRIER_PATH;
                while ((long)(list = this.zk.getChildrenExt(barrierPath, true, false, false)).size() < workersNum) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(timeout);
                    }
                    context.progress();
                }
                return;
            }
            catch (KeeperException ke) {
                throw new InterruptedException("Error while checking the barrier:" + ke.getMessage());
            }
        }

        private void startConnection() throws IOException, InterruptedException {
            this.rexsterConn = RexsterUtils.Vertex.openOutputConnection(this.getConf());
            this.rexsterBufferedStream = new BufferedWriter(new OutputStreamWriter(this.rexsterConn.getOutputStream(), Charset.forName("UTF-8")));
            this.rexsterBufferedStream.write("{ ");
            this.rexsterBufferedStream.write("\"vlabel\" : \"" + this.vlabel + "\",");
            this.rexsterBufferedStream.write("\"tx\"");
            this.rexsterBufferedStream.write(" : [ ");
        }

        private void stopConnection() throws IOException, InterruptedException {
            this.rexsterBufferedStream.write(" ] }");
            this.rexsterBufferedStream.flush();
            this.rexsterBufferedStream.close();
            RexsterUtils.Vertex.handleResponse(this.rexsterConn);
        }

        protected JSONObject getVertex(Vertex<I, V, E> vertex) throws JSONException {
            this.vertexId = vertex.getId();
            String value = vertex.getValue().toString();
            JSONObject jsonVertex = new JSONObject();
            jsonVertex.accumulate("value", (Object)value);
            return jsonVertex;
        }

        protected I getVertexId() {
            return this.vertexId;
        }
    }

    private static class NullOutputCommitter
    extends OutputCommitter {
        private NullOutputCommitter() {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void setupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }
    }
}

