/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.rexster.conf.GiraphRexsterConstants;
import org.apache.giraph.rexster.io.RexsterInputSplit;
import org.apache.giraph.rexster.utils.RexsterUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class RexsterVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    private static final Logger LOG = Logger.getLogger(RexsterVertexInputFormat.class);

    public void checkInputSpecs(Configuration conf) {
        GiraphConfiguration gconf = new GiraphConfiguration(conf);
        if (!gconf.hasEdgeInputFormat()) {
            String err = "Rexster Input I/O requires both Vertex- and EdgeInputFormat.";
            LOG.error((Object)err);
            throw new RuntimeException(err);
        }
        String endpoint = GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.get(conf);
        if (endpoint == null) {
            throw new RuntimeException(GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.getKey() + " is a mandatory parameter.");
        }
    }

    public abstract RexsterVertexReader createVertexReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return RexsterUtils.getSplits(context, GiraphRexsterConstants.GIRAPH_REXSTER_V_ESTIMATE.get((Configuration)this.getConf()));
    }

    protected abstract class RexsterVertexReader
    extends VertexReader<I, V, E> {
        private BufferedReader rexsterBufferedStream;
        private JSONTokener tokener;
        private long splitStart;
        private long splitEnd;
        private long itemsIterated = 0L;
        private Vertex<I, V, E> vertex;
        private boolean isFirstVertex;

        protected RexsterVertexReader() {
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            RexsterInputSplit rexsterInputSplit = (RexsterInputSplit)inputSplit;
            this.splitEnd = rexsterInputSplit.getEnd();
            this.splitStart = rexsterInputSplit.getStart();
            this.rexsterBufferedStream = RexsterUtils.Vertex.openInputStream(this.getConf(), this.splitStart, this.splitEnd);
            this.tokener = RexsterUtils.parseJSONEnvelope(this.rexsterBufferedStream);
            this.isFirstVertex = true;
        }

        public boolean nextVertex() throws IOException, InterruptedException {
            try {
                char c;
                if (this.tokener == null) {
                    return false;
                }
                if (this.isFirstVertex) {
                    this.isFirstVertex = false;
                    c = this.tokener.nextClean();
                    if (c == ']') {
                        return false;
                    }
                    this.tokener.back();
                }
                JSONObject obj = new JSONObject(this.tokener);
                this.vertex = this.parseVertex(obj);
                c = this.tokener.nextClean();
                if (c == ',') {
                    ++this.itemsIterated;
                    return true;
                }
                if (c == ']') {
                    return false;
                }
                LOG.error((Object)String.format("Expected a '%c' at the end of the array", Character.valueOf(']')));
                throw new InterruptedException(String.format("Expected a '%c' at the end of the array", Character.valueOf(']')));
            }
            catch (JSONException e) {
                throw new InterruptedException(e.toString());
            }
        }

        public void close() throws IOException {
            this.rexsterBufferedStream.close();
        }

        public float getProgress() throws IOException, InterruptedException {
            float vestimated = GiraphRexsterConstants.GIRAPH_REXSTER_V_ESTIMATE.get((Configuration)this.getConf());
            if (this.splitStart == this.splitEnd) {
                return 0.0f;
            }
            return Math.min(1.0f, (float)this.itemsIterated / vestimated);
        }

        public Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
            return this.vertex;
        }

        protected abstract Vertex<I, V, E> parseVertex(JSONObject var1) throws JSONException;
    }
}

