/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class RexsterInputSplit
extends InputSplit
implements Writable {
    private long end = 0L;
    private long start = 0L;

    public RexsterInputSplit() {
    }

    public RexsterInputSplit(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public String[] getLocations() {
        return new String[0];
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.end - this.start;
    }

    public void readFields(DataInput input) throws IOException {
        this.start = input.readLong();
        this.end = input.readLong();
    }

    public void write(DataOutput output) throws IOException {
        output.writeLong(this.start);
        output.writeLong(this.end);
    }

    public String toString() {
        return String.format("Split at [%s to %s]", this.start, this.end == Long.MAX_VALUE ? "END" : Long.valueOf(this.end - 1L));
    }
}

