/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.EdgeWriter;
import org.apache.giraph.rexster.conf.GiraphRexsterConstants;
import org.apache.giraph.rexster.utils.RexsterUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class RexsterEdgeOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends EdgeOutputFormat<I, V, E> {
    private static final Logger LOG = Logger.getLogger(RexsterEdgeOutputFormat.class);

    public RexsterEdgeWriter createEdgeWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new RexsterEdgeWriter();
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        GiraphConfiguration gconf = new GiraphConfiguration(context.getConfiguration());
        String msg = "Rexster OutputFormat usage requires both Edge and Vertex OutputFormat's.";
        if (!gconf.hasVertexOutputFormat()) {
            LOG.error((Object)msg);
            throw new InterruptedException(msg);
        }
        String endpoint = GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.get((Configuration)gconf);
        if (endpoint == null) {
            throw new InterruptedException(GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.getKey() + " is a mandatory parameter.");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    protected class RexsterEdgeWriter
    extends EdgeWriter<I, V, E> {
        private static final String JSON_ARRAY_KEY = "tx";
        private HttpURLConnection rexsterConn;
        private BufferedWriter rexsterBufferedStream;
        private boolean isFirstElement = true;
        private int txsize;
        private int txcounter = 0;
        private String vlabel;
        private int backoffDelay = 0;
        private int backoffRetry = 0;

        protected RexsterEdgeWriter() {
        }

        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            this.txsize = GiraphRexsterConstants.GIRAPH_REXSTER_OUTPUT_E_TXSIZE.get((Configuration)this.getConf());
            this.vlabel = GiraphRexsterConstants.GIRAPH_REXSTER_VLABEL.get((Configuration)this.getConf());
            this.backoffDelay = GiraphRexsterConstants.GIRAPH_REXSTER_BACKOFF_DELAY.get((Configuration)this.getConf());
            this.backoffRetry = GiraphRexsterConstants.GIRAPH_REXSTER_BACKOFF_RETRY.get((Configuration)this.getConf());
            this.startConnection();
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.stopConnection();
        }

        public void writeEdge(I srcId, V srcValue, Edge<I, E> edge) throws IOException, InterruptedException {
            if (this.txcounter == this.txsize) {
                this.txcounter = 0;
                this.isFirstElement = true;
                this.stopConnection();
                this.startConnection();
            }
            try {
                String suffix;
                JSONObject jsonEdge = this.getEdge(srcId, srcValue, edge);
                if (this.isFirstElement) {
                    this.isFirstElement = false;
                    suffix = "";
                } else {
                    suffix = ",";
                }
                this.rexsterBufferedStream.write(suffix + jsonEdge);
                ++this.txcounter;
            }
            catch (JSONException e) {
                throw new InterruptedException("Error writing the edge: " + e.getMessage());
            }
        }

        private void startConnection() throws IOException, InterruptedException {
            this.rexsterConn = RexsterUtils.Edge.openOutputConnection(this.getConf());
            this.rexsterBufferedStream = new BufferedWriter(new OutputStreamWriter(this.rexsterConn.getOutputStream(), Charset.forName("UTF-8")));
            this.rexsterBufferedStream.write("{ ");
            this.rexsterBufferedStream.write("\"vlabel\" : \"" + this.vlabel + "\",");
            this.rexsterBufferedStream.write("\"delay\" : \"" + this.backoffDelay + "\",");
            this.rexsterBufferedStream.write("\"retry\" : \"" + this.backoffRetry + "\",");
            this.rexsterBufferedStream.write("\"tx\"");
            this.rexsterBufferedStream.write(" : [ ");
        }

        private void stopConnection() throws IOException, InterruptedException {
            this.rexsterBufferedStream.write(" ] }");
            this.rexsterBufferedStream.flush();
            this.rexsterBufferedStream.close();
            RexsterUtils.Edge.handleResponse(this.rexsterConn);
        }

        protected JSONObject getEdge(I srcId, V srcValue, Edge<I, E> edge) throws JSONException {
            String outId = srcId.toString();
            String inId = edge.getTargetVertexId().toString();
            String value = edge.getValue().toString();
            JSONObject jsonEdge = new JSONObject();
            jsonEdge.accumulate("_outV", (Object)outId);
            jsonEdge.accumulate("_inV", (Object)inId);
            jsonEdge.accumulate("value", (Object)value);
            return jsonEdge;
        }
    }

    private static class NullOutputCommitter
    extends OutputCommitter {
        private NullOutputCommitter() {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void setupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }
    }
}

