/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.rexster.conf.GiraphRexsterConstants;
import org.apache.giraph.rexster.io.RexsterInputSplit;
import org.apache.giraph.rexster.utils.RexsterUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class RexsterEdgeInputFormat<I extends WritableComparable, E extends Writable>
extends EdgeInputFormat<I, E> {
    private static final Logger LOG = Logger.getLogger(RexsterEdgeInputFormat.class);

    public void checkInputSpecs(Configuration conf) {
        GiraphConfiguration gconf = new GiraphConfiguration(conf);
        String msg = "Rexster InputFormat usage requires both Edge and Vertex InputFormat's.";
        if (!gconf.hasVertexInputFormat()) {
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
        String endpoint = GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.get(conf);
        if (endpoint == null) {
            throw new RuntimeException(GiraphRexsterConstants.GIRAPH_REXSTER_HOSTNAME.getKey() + " is a mandatory parameter.");
        }
    }

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return RexsterUtils.getSplits(context, GiraphRexsterConstants.GIRAPH_REXSTER_E_ESTIMATE.get((Configuration)this.getConf()));
    }

    public abstract RexsterEdgeReader createEdgeReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    protected abstract class RexsterEdgeReader
    extends EdgeReader<I, E> {
        private BufferedReader rexsterBufferedStream;
        private JSONTokener tokener;
        private long splitStart;
        private long splitEnd;
        private long itemsIterated = 0L;
        private Edge<I, E> edge;
        private boolean isFirstEdge;

        protected RexsterEdgeReader() {
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            RexsterInputSplit rexsterInputSplit = (RexsterInputSplit)inputSplit;
            this.splitEnd = rexsterInputSplit.getEnd();
            this.splitStart = rexsterInputSplit.getStart();
            this.rexsterBufferedStream = RexsterUtils.Edge.openInputStream(this.getConf(), this.splitStart, this.splitEnd);
            this.tokener = RexsterUtils.parseJSONEnvelope(this.rexsterBufferedStream);
            this.isFirstEdge = true;
        }

        public void close() throws IOException {
            this.rexsterBufferedStream.close();
        }

        public float getProgress() throws IOException, InterruptedException {
            float estimated = GiraphRexsterConstants.GIRAPH_REXSTER_E_ESTIMATE.get((Configuration)this.getConf());
            if (this.splitStart == this.splitEnd) {
                return 0.0f;
            }
            return Math.min(1.0f, (float)this.itemsIterated / estimated);
        }

        public Edge<I, E> getCurrentEdge() throws IOException, InterruptedException {
            return this.edge;
        }

        public boolean nextEdge() throws IOException, InterruptedException {
            try {
                char c;
                if (this.tokener == null) {
                    return false;
                }
                if (this.isFirstEdge) {
                    c = this.tokener.nextClean();
                    this.isFirstEdge = false;
                    if (c == ']') {
                        return false;
                    }
                    this.tokener.back();
                }
                JSONObject obj = new JSONObject(this.tokener);
                this.edge = this.parseEdge(obj);
                LOG.info(this.edge);
                c = this.tokener.nextClean();
                if (c == ',') {
                    ++this.itemsIterated;
                    return true;
                }
                if (c == ']') {
                    return false;
                }
                LOG.error((Object)String.format("Expected a '%c' at the end of the array", Character.valueOf(']')));
                throw new InterruptedException();
            }
            catch (JSONException e) {
                throw new InterruptedException(e.toString());
            }
        }

        protected abstract Edge<I, E> parseEdge(JSONObject var1) throws JSONException;

        public abstract I getCurrentSourceId() throws IOException, InterruptedException;
    }
}

