/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.conf;

import org.apache.giraph.conf.BooleanConfOption;
import org.apache.giraph.conf.IntConfOption;
import org.apache.giraph.conf.StrConfOption;

public interface GiraphRexsterConstants {
    public static final StrConfOption GIRAPH_REXSTER_HOSTNAME = new StrConfOption("giraph.rexster.hostname", null, "Rexster hostname which provides the REST API. - required");
    public static final IntConfOption GIRAPH_REXSTER_PORT = new IntConfOption("giraph.rexster.port", 8182, "Rexster port where to contact the REST API.");
    public static final BooleanConfOption GIRAPH_REXSTER_USES_SSL = new BooleanConfOption("giraph.rexster.ssl", false, "Rexster flag to set the connection over SSL instaed of clear-text.");
    public static final StrConfOption GIRAPH_REXSTER_USERNAME = new StrConfOption("giraph.rexster.username", "", "Rexster username to access the REST API.");
    public static final StrConfOption GIRAPH_REXSTER_PASSWORD = new StrConfOption("giraph.rexster.password", "", "Rexster password to access the REST API.");
    public static final StrConfOption GIRAPH_REXSTER_INPUT_GRAPH = new StrConfOption("giraph.rexster.input.graph", "graphdb", "Rexster input graph.");
    public static final IntConfOption GIRAPH_REXSTER_V_ESTIMATE = new IntConfOption("giraph.rexster.input.vertex", 1000, "Rexster number of estimated vertexes in the graph to be loaded.");
    public static final IntConfOption GIRAPH_REXSTER_E_ESTIMATE = new IntConfOption("giraph.rexster.input.edges", 1000, "Rexster number of estimated vertex in the graph to be loaded.");
    public static final StrConfOption GIRAPH_REXSTER_GREMLIN_V_SCRIPT = new StrConfOption("giraph.rexster.input.vertex.gremlinScript", "", "If the database is Gremlin enabled, the script will be used to retrieve the vertexes from the Rexster exposed database.");
    public static final StrConfOption GIRAPH_REXSTER_GREMLIN_E_SCRIPT = new StrConfOption("giraph.rexster.input.edges.gremlinScript", "", "If the database is Gremlin enabled, the script will be used to retrieve the edges from the Rexster exposed database.");
    public static final StrConfOption GIRAPH_REXSTER_OUTPUT_GRAPH = new StrConfOption("giraph.rexster.output.graph", "graphdb", "Rexster output graph.");
    public static final StrConfOption GIRAPH_REXSTER_VLABEL = new StrConfOption("giraph.rexster.output.vlabel", "_vid", "Rexster Vertex ID label for the JSON format.");
    public static final IntConfOption GIRAPH_REXSTER_BACKOFF_DELAY = new IntConfOption("giraph.rexster.output.backoffDelay", 5, "Rexster back-off delay in milliseconds which is multiplied to an exponentially increasing counter. Needed to deal with deadlocks and consistency raised by the graph database.");
    public static final IntConfOption GIRAPH_REXSTER_BACKOFF_RETRY = new IntConfOption("giraph.rexster.output.backoffRetry", 20, "Rexster back-off number of retries in case of failures. Needed to deal with deadlocks and consistency raised by the graph database.");
    public static final IntConfOption GIRAPH_REXSTER_OUTPUT_WAIT_TIMEOUT = new IntConfOption("giraph.rexster.output.timeout", 10, "Rexster output format wait timeout (seconds). This is used to wake up the thread to call progress very x seconds if not progress from the ZooKeeper is detected.");
    public static final IntConfOption GIRAPH_REXSTER_OUTPUT_V_TXSIZE = new IntConfOption("giraph.rexster.output.vertex.txsize", 1000, "Rexster Output format transaction size. This parameterdefines how many vertexes are sent for each transaction.");
    public static final IntConfOption GIRAPH_REXSTER_OUTPUT_E_TXSIZE = new IntConfOption("giraph.rexster.output.edge.txsize", 1000, "Rexster Output format transaction size. This parameterdefines how many edges are sent for each transaction.");
}

