/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.primitives;

import com.facebook.hiveio.record.HiveWritableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.base.Preconditions;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.values.HiveValueWriter;
import org.apache.giraph.types.WritableUnwrapper;
import org.apache.giraph.types.WritableUnwrappers;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class PrimitiveValueWriter<W extends Writable>
implements HiveValueWriter<W> {
    private final int columnIndex;
    private final WritableUnwrapper<W, Object> writableUnwrapper;

    public PrimitiveValueWriter(int columnIndex, WritableUnwrapper<W, Object> writableUnwrapper) {
        Preconditions.checkNotNull(writableUnwrapper);
        this.columnIndex = columnIndex;
        this.writableUnwrapper = writableUnwrapper;
    }

    public static <T extends Writable> HiveValueWriter<T> create(ImmutableClassesGiraphConfiguration conf, StrConfOption columnOption, HiveTableSchema schema, GraphType graphType) {
        Class valueClass = graphType.get(conf);
        if (NullWritable.class.isAssignableFrom(valueClass)) {
            return HiveValueWriter.Null.get();
        }
        int columnIndex = HiveUtils.columnIndexOrThrow(schema, (Configuration)conf, columnOption);
        Class hiveClass = schema.columnType(columnIndex).javaClass();
        WritableUnwrapper unwrapper = WritableUnwrappers.lookup((Class)valueClass, (Class)hiveClass);
        return new PrimitiveValueWriter(columnIndex, unwrapper);
    }

    @Override
    public void write(W value, HiveWritableRecord record) {
        Object object = this.writableUnwrapper.unwrap(value);
        record.set(this.columnIndex, object);
    }
}

