/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.primitives;

import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.base.Preconditions;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.values.HiveValueReader;
import org.apache.giraph.types.WritableWrapper;
import org.apache.giraph.types.WritableWrappers;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class PrimitiveValueReader<W extends Writable>
implements HiveValueReader<W> {
    private final int columnIndex;
    private final WritableWrapper<W, Object> writableWrapper;

    public PrimitiveValueReader(int columnIndex, WritableWrapper<W, Object> writableWrapper) {
        Preconditions.checkNotNull(writableWrapper);
        this.columnIndex = columnIndex;
        this.writableWrapper = writableWrapper;
    }

    public static <W extends Writable> HiveValueReader<W> create(ImmutableClassesGiraphConfiguration conf, GraphType graphType, StrConfOption columnOption, HiveTableSchema schema) {
        Class valueClass = graphType.get(conf);
        if (NullWritable.class.isAssignableFrom(valueClass)) {
            return HiveValueReader.Null.get();
        }
        int columnIndex = HiveUtils.columnIndexOrThrow(schema, (Configuration)conf, columnOption);
        Class hiveClass = schema.columnType(columnIndex).javaClass();
        WritableWrapper wrapper = WritableWrappers.lookup((Class)valueClass, (Class)hiveClass);
        return new PrimitiveValueReader<W>(columnIndex, wrapper);
    }

    @Override
    public void readFields(W value, HiveReadableRecord record) {
        Object object = record.get(this.columnIndex);
        this.writableWrapper.wrap(object, value);
    }
}

