/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.output;

import com.facebook.hiveio.record.HiveRecordFactory;
import com.facebook.hiveio.record.HiveWritableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import java.io.IOException;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.output.HiveRecordSaver;
import org.apache.giraph.hive.output.VertexToHive;
import org.apache.giraph.io.VertexWriter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class HiveVertexWriter<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexWriter<I, V, E>
implements HiveRecordSaver {
    private static final Logger LOG = Logger.getLogger(HiveVertexWriter.class);
    private RecordWriter<WritableComparable, HiveWritableRecord> hiveRecordWriter;
    private HiveTableSchema tableSchema;
    private HiveWritableRecord reusableRecord;
    private VertexToHive<I, V, E> vertexToHive;

    public RecordWriter<WritableComparable, HiveWritableRecord> getBaseWriter() {
        return this.hiveRecordWriter;
    }

    public void setBaseWriter(RecordWriter<WritableComparable, HiveWritableRecord> hiveRecordWriter) {
        this.hiveRecordWriter = hiveRecordWriter;
    }

    public HiveTableSchema getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(HiveTableSchema tableSchema) {
        this.tableSchema = tableSchema;
        this.reusableRecord = HiveRecordFactory.newWritableRecord((HiveTableSchema)tableSchema);
    }

    public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
        this.vertexToHive = HiveUtils.newVertexToHive(this.getConf(), this.tableSchema);
        this.vertexToHive.initialize();
    }

    public void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
        this.vertexToHive.saveVertex(vertex, this.reusableRecord, this);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.hiveRecordWriter.close(context);
    }

    @Override
    public void save(HiveWritableRecord record) throws IOException, InterruptedException {
        this.hiveRecordWriter.write((Object)NullWritable.get(), (Object)record);
    }
}

