/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.output;

import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.output.HiveApiOutputFormat;
import com.facebook.hiveio.output.HiveOutputDescription;
import com.facebook.hiveio.output.RecordWriterImpl;
import com.facebook.hiveio.record.HiveRecordFactory;
import com.facebook.hiveio.record.HiveWritableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.output.HiveVertexWriter;
import org.apache.giraph.hive.output.VertexToHive;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HiveVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    private final HiveApiOutputFormat hiveOutputFormat = new HiveApiOutputFormat();

    private HiveOutputDescription makeOutputDesc() {
        HiveOutputDescription outputDesc = new HiveOutputDescription();
        HiveTableDesc tableDesc = outputDesc.getTableDesc();
        tableDesc.setDatabaseName(GiraphHiveConstants.HIVE_VERTEX_OUTPUT_DATABASE.get((Configuration)this.getConf()));
        tableDesc.setTableName(GiraphHiveConstants.HIVE_VERTEX_OUTPUT_TABLE.get((Configuration)this.getConf()));
        outputDesc.setPartitionValues(HiveUtils.parsePartitionValues(GiraphHiveConstants.HIVE_VERTEX_OUTPUT_PARTITION.get((Configuration)this.getConf())));
        return outputDesc;
    }

    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        super.setConf(conf);
        this.hiveOutputFormat.initialize(this.makeOutputDesc(), GiraphHiveConstants.HIVE_VERTEX_OUTPUT_PROFILE_ID.get(conf), conf);
    }

    public VertexWriter<I, V, E> createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        RecordWriterImpl baseWriter = this.hiveOutputFormat.getRecordWriter(context);
        HiveVertexWriter writer = new HiveVertexWriter();
        writer.setBaseWriter((RecordWriter<WritableComparable, HiveWritableRecord>)baseWriter);
        writer.setTableSchema(this.hiveOutputFormat.getTableSchema((Configuration)this.getConf()));
        return writer;
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.hiveOutputFormat.checkOutputSpecs(context);
        HiveTableSchema schema = this.hiveOutputFormat.getTableSchema((Configuration)this.getConf());
        VertexToHive vertexToHive = HiveUtils.newVertexToHive(this.getConf(), schema);
        vertexToHive.checkOutput(this.makeOutputDesc(), schema, HiveRecordFactory.newWritableRecord((HiveTableSchema)schema));
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.hiveOutputFormat.getOutputCommitter(context);
    }
}

