/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.jython;

import com.facebook.hiveio.output.HiveOutputDescription;
import com.facebook.hiveio.record.HiveWritableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.jython.HiveJythonUtils;
import org.apache.giraph.hive.output.SimpleVertexToHive;
import org.apache.giraph.hive.values.HiveValueWriter;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class JythonVertexToHive<I extends WritableComparable, V extends Writable, E extends Writable>
extends SimpleVertexToHive<I, V, E> {
    public static final StrConfOption VERTEX_ID_COLUMN = new StrConfOption("hive.output.vertex.id.column", null, "Source Vertex ID column");
    public static final StrConfOption VERTEX_VALUE_COLUMN = new StrConfOption("hive.output.vertex.value.column", null, "Target Vertex ID column");
    private HiveValueWriter<I> vertexIdWriter;
    private HiveValueWriter<V> vertexValueWriter;

    @Override
    public void checkOutput(HiveOutputDescription outputDesc, HiveTableSchema schema, HiveWritableRecord emptyRecord) {
    }

    @Override
    public void initialize() {
        HiveTableSchema schema = this.getTableSchema();
        ImmutableClassesGiraphConfiguration conf = this.getConf();
        this.vertexIdWriter = HiveJythonUtils.newValueWriter(schema, VERTEX_ID_COLUMN, conf, GraphType.VERTEX_ID, GiraphHiveConstants.VERTEX_ID_WRITER_JYTHON_NAME);
        this.vertexValueWriter = HiveJythonUtils.newValueWriter(schema, VERTEX_VALUE_COLUMN, conf, GraphType.VERTEX_VALUE, GiraphHiveConstants.VERTEX_VALUE_WRITER_JYTHON_NAME);
    }

    @Override
    public void fillRecord(Vertex<I, V, E> vertex, HiveWritableRecord record) {
        this.vertexIdWriter.write(vertex.getId(), record);
        this.vertexValueWriter.write(vertex.getValue(), record);
    }
}

