/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.jython;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.record.HiveReadableRecord;
import org.apache.giraph.hive.column.HiveReadableColumn;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;

public class JythonReadableColumn {
    private final HiveReadableColumn column = new HiveReadableColumn();

    public void setRecord(HiveReadableRecord record) {
        this.column.setRecord(record);
    }

    public void setIndex(int index) {
        this.column.setIndex(index);
    }

    public PyBoolean getBoolean() {
        return new PyBoolean(this.column.getBoolean());
    }

    public PyInteger getByte() {
        return this.getInt();
    }

    public PyInteger getShort() {
        return this.getInt();
    }

    public PyInteger getInt() {
        int value;
        if (this.column.hiveType() == HiveType.BYTE) {
            value = this.column.getByte();
        } else if (this.column.hiveType() == HiveType.SHORT) {
            value = this.column.getShort();
        } else if (this.column.hiveType() == HiveType.LONG) {
            value = this.column.getInt();
        } else {
            throw new IllegalArgumentException("Column is not a byte/short/int, is " + this.column.hiveType());
        }
        return new PyInteger(value);
    }

    public PyLong getLong() {
        return new PyLong(this.column.getLong());
    }

    public PyFloat getDouble() {
        return this.getFloat();
    }

    public PyFloat getFloat() {
        double value;
        if (this.column.hiveType() == HiveType.FLOAT) {
            value = this.column.getFloat();
        } else if (this.column.hiveType() == HiveType.DOUBLE) {
            value = this.column.getDouble();
        } else {
            throw new IllegalArgumentException("Column is not a float/double, is " + this.column.hiveType());
        }
        return new PyFloat(value);
    }

    public PyString getString() {
        return new PyString(this.column.getString());
    }

    public PyList getList() {
        return new PyList(this.column.getList());
    }

    public PyDictionary getMap() {
        PyDictionary dict = new PyDictionary();
        dict.putAll(this.column.getMap());
        return dict;
    }

    public PyObject get() {
        return Py.java2py((Object)this.column.get());
    }
}

