/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.jython;

import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.input.vertex.SimpleHiveToVertex;
import org.apache.giraph.hive.jython.HiveJythonUtils;
import org.apache.giraph.hive.values.HiveValueReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class JythonHiveToVertex<I extends WritableComparable, V extends Writable, E extends Writable>
extends SimpleHiveToVertex<I, V, E> {
    public static final StrConfOption VERTEX_ID_COLUMN = new StrConfOption("hive.input.vertex.id.column", null, "Vertex ID column");
    public static final StrConfOption VERTEX_VALUE_COLUMN = new StrConfOption("hive.input.vertex.value.column", null, "Vertex Value column");
    private HiveValueReader<I> vertexIdReader;
    private HiveValueReader<V> vertexValueReader;

    @Override
    public void checkInput(HiveInputDescription inputDesc, HiveTableSchema schema) {
    }

    @Override
    public void initializeRecords(Iterator<HiveReadableRecord> records) {
        super.initializeRecords(records);
        HiveTableSchema schema = this.getTableSchema();
        ImmutableClassesGiraphConfiguration conf = this.getConf();
        this.vertexIdReader = HiveJythonUtils.newValueReader(schema, VERTEX_ID_COLUMN, conf, GraphType.VERTEX_ID, GiraphHiveConstants.VERTEX_ID_READER_JYTHON_NAME);
        this.vertexValueReader = HiveJythonUtils.newValueReader(schema, VERTEX_VALUE_COLUMN, conf, GraphType.VERTEX_VALUE, GiraphHiveConstants.VERTEX_VALUE_READER_JYTHON_NAME);
    }

    @Override
    public Iterable<Edge<I, E>> getEdges(HiveReadableRecord record) {
        return ImmutableList.of();
    }

    @Override
    public I getVertexId(HiveReadableRecord record) {
        Object vertexId = this.getReusableVertexId();
        this.vertexIdReader.readFields(vertexId, record);
        return vertexId;
    }

    @Override
    public V getVertexValue(HiveReadableRecord record) {
        Object vertexValue = this.getReusableVertexValue();
        this.vertexValueReader.readFields(vertexValue, record);
        return vertexValue;
    }
}

