/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.jython;

import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import java.util.Iterator;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.input.edge.SimpleHiveToEdge;
import org.apache.giraph.hive.jython.HiveJythonUtils;
import org.apache.giraph.hive.values.HiveValueReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class JythonHiveToEdge<I extends WritableComparable, E extends Writable>
extends SimpleHiveToEdge<I, E> {
    public static final StrConfOption EDGE_SOURCE_ID_COLUMN = new StrConfOption("hive.input.edge.source.id.column", null, "Source Vertex ID column");
    public static final StrConfOption EDGE_TARGET_ID_COLUMN = new StrConfOption("hive.input.edge.target.id.column", null, "Target Vertex ID column");
    public static final StrConfOption EDGE_VALUE_COLUMN = new StrConfOption("hive.input.edge.value.column", null, "Edge Value column");
    private HiveValueReader<I> sourceIdReader;
    private HiveValueReader<I> targetIdReader;
    private HiveValueReader<E> edgeValueReader;

    @Override
    public void checkInput(HiveInputDescription inputDesc, HiveTableSchema schema) {
    }

    @Override
    public void initializeRecords(Iterator<HiveReadableRecord> records) {
        super.initializeRecords(records);
        HiveTableSchema schema = this.getTableSchema();
        ImmutableClassesGiraphConfiguration conf = this.getConf();
        this.sourceIdReader = HiveJythonUtils.newValueReader(schema, EDGE_SOURCE_ID_COLUMN, conf, GraphType.VERTEX_ID, GiraphHiveConstants.VERTEX_ID_READER_JYTHON_NAME);
        this.targetIdReader = HiveJythonUtils.newValueReader(schema, EDGE_TARGET_ID_COLUMN, conf, GraphType.VERTEX_ID, GiraphHiveConstants.VERTEX_ID_READER_JYTHON_NAME);
        this.edgeValueReader = HiveJythonUtils.newValueReader(schema, EDGE_VALUE_COLUMN, conf, GraphType.EDGE_VALUE, GiraphHiveConstants.EDGE_VALUE_READER_JYTHON_NAME);
    }

    @Override
    public I getSourceVertexId(HiveReadableRecord record) {
        Object sourceId = this.getReusableSourceVertexId();
        this.sourceIdReader.readFields(sourceId, record);
        return sourceId;
    }

    @Override
    public I getTargetVertexId(HiveReadableRecord record) {
        Object targetId = this.getReusableTargetVertexId();
        this.targetIdReader.readFields(targetId, record);
        return targetId;
    }

    @Override
    public E getEdgeValue(HiveReadableRecord record) {
        Object edgeValue = this.getReusableEdgeValue();
        this.edgeValueReader.readFields(edgeValue, record);
        return edgeValue;
    }
}

