/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.jython;

import com.facebook.hiveio.record.HiveWritableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.hive.column.HiveWritableColumn;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.jython.JythonHiveWriter;
import org.apache.giraph.hive.values.HiveValueWriter;
import org.apache.giraph.jython.JythonUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.python.core.PyObject;

public class JythonColumnWriter<W extends Writable>
implements HiveValueWriter<W> {
    private HiveWritableColumn column = new HiveWritableColumn();
    private final JythonHiveWriter jythonHiveWriter;

    public JythonColumnWriter(int columnIndex, JythonHiveWriter jythonHiveWriter) {
        this.column.setIndex(columnIndex);
        this.jythonHiveWriter = jythonHiveWriter;
    }

    public static <W extends Writable> JythonColumnWriter<W> create(ImmutableClassesGiraphConfiguration conf, StrConfOption jythonClassOption, StrConfOption columnOption, HiveTableSchema schema) {
        String className = jythonClassOption.get((Configuration)conf);
        PyObject pyClass = JythonUtils.getInterpreter().get(className);
        JythonHiveWriter jythonColumnWritable = (JythonHiveWriter)pyClass.__call__().__tojava__(JythonHiveWriter.class);
        int columnIndex = HiveUtils.columnIndexOrThrow(schema, (Configuration)conf, columnOption);
        return new JythonColumnWriter<W>(columnIndex, jythonColumnWritable);
    }

    @Override
    public void write(W value, HiveWritableRecord record) {
        this.column.setRecord(record);
        this.jythonHiveWriter.writeToHive(value, this.column);
    }
}

