/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.jython;

import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.jython.JythonHiveReader;
import org.apache.giraph.hive.jython.JythonReadableColumn;
import org.apache.giraph.hive.values.HiveValueReader;
import org.apache.giraph.jython.JythonUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.python.core.PyObject;

public class JythonColumnReader<T extends Writable>
implements HiveValueReader<T> {
    private JythonReadableColumn column = new JythonReadableColumn();
    private final JythonHiveReader jythonHiveReader;

    public JythonColumnReader(int columnIndex, JythonHiveReader jythonHiveReader) {
        this.column.setIndex(columnIndex);
        this.jythonHiveReader = jythonHiveReader;
    }

    public static <T extends Writable> JythonColumnReader<T> create(ImmutableClassesGiraphConfiguration conf, StrConfOption jythonClassOption, StrConfOption columnOption, HiveTableSchema schema) {
        PyObject pyClass = JythonUtils.getInterpreter().get(jythonClassOption.get((Configuration)conf));
        JythonHiveReader jythonHiveReader = (JythonHiveReader)pyClass.__call__().__tojava__(JythonHiveReader.class);
        int columnIndex = HiveUtils.columnIndexOrThrow(schema, (Configuration)conf, columnOption);
        return new JythonColumnReader<T>(columnIndex, jythonHiveReader);
    }

    @Override
    public void readFields(T value, HiveReadableRecord record) {
        this.column.setRecord(record);
        this.jythonHiveReader.readFromHive(value, this.column);
    }
}

