/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.jython;

import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.GiraphTypes;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.graph.Language;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.common.LanguageAndType;
import org.apache.giraph.hive.input.edge.HiveEdgeInputFormat;
import org.apache.giraph.hive.input.vertex.HiveVertexInputFormat;
import org.apache.giraph.hive.jython.JythonColumnReader;
import org.apache.giraph.hive.jython.JythonColumnWriter;
import org.apache.giraph.hive.jython.JythonHiveReader;
import org.apache.giraph.hive.jython.JythonHiveToEdge;
import org.apache.giraph.hive.jython.JythonHiveToVertex;
import org.apache.giraph.hive.jython.JythonHiveWriter;
import org.apache.giraph.hive.jython.JythonVertexToHive;
import org.apache.giraph.hive.output.HiveVertexOutputFormat;
import org.apache.giraph.hive.primitives.PrimitiveValueReader;
import org.apache.giraph.hive.primitives.PrimitiveValueWriter;
import org.apache.giraph.hive.values.HiveValueReader;
import org.apache.giraph.hive.values.HiveValueWriter;
import org.apache.giraph.io.formats.multi.MultiEdgeInputFormat;
import org.apache.giraph.io.formats.multi.MultiVertexInputFormat;
import org.apache.giraph.jython.JythonJob;
import org.apache.giraph.jython.JythonUtils;
import org.apache.giraph.jython.factories.JythonEdgeValueFactory;
import org.apache.giraph.jython.factories.JythonFactoryBase;
import org.apache.giraph.jython.factories.JythonIncomingMessageValueFactory;
import org.apache.giraph.jython.factories.JythonOutgoingMessageValueFactory;
import org.apache.giraph.jython.factories.JythonVertexIdFactory;
import org.apache.giraph.jython.factories.JythonVertexValueFactory;
import org.apache.giraph.jython.wrappers.JythonWritableWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class HiveJythonUtils {
    private static final Logger LOG = Logger.getLogger(HiveJythonUtils.class);

    private HiveJythonUtils() {
    }

    public static String[] processArgs(String[] args, Configuration conf) {
        HiveUtils.addHadoopClasspathToTmpJars(conf);
        HiveUtils.addHiveSiteXmlToTmpFiles(conf);
        HiveUtils.addHiveSiteCustomXmlToTmpFiles(conf);
        return HiveJythonUtils.moveHiveconfOptionsToConf(args, conf);
    }

    private static String[] moveHiveconfOptionsToConf(String[] args, Configuration conf) {
        int start;
        for (start = 0; start < args.length && args[start].endsWith("hiveconf"); start += 2) {
            HiveUtils.processHiveconfOption(conf, args[start + 1]);
        }
        return Arrays.copyOfRange(args, start, args.length);
    }

    public static JythonJob parseJythonFiles(PythonInterpreter interpreter, String ... paths) throws IOException {
        return HiveJythonUtils.parseJythonFiles(interpreter, Arrays.asList(paths));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JythonJob parseJythonFiles(PythonInterpreter interpreter, List<String> paths) throws IOException {
        JythonJob jythonJob;
        InputStream[] streams = new InputStream[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            LOG.info((Object)("Reading jython file " + paths.get(i)));
            streams[i] = new FileInputStream(paths.get(i));
        }
        try {
            jythonJob = HiveJythonUtils.parseJythonStreams(interpreter, streams);
        }
        finally {
            for (InputStream stream : streams) {
                Closeables.close((Closeable)stream, (boolean)true);
            }
        }
        return jythonJob;
    }

    public static JythonJob parseJythonStreams(PythonInterpreter interpreter, InputStream ... streams) {
        for (InputStream stream : streams) {
            HiveJythonUtils.readJythonStream(interpreter, stream);
        }
        PyObject pyPrepare = interpreter.get("prepare");
        JythonJob jythonJob = new JythonJob();
        pyPrepare._jcall(new Object[]{jythonJob});
        return jythonJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readJythonStream(PythonInterpreter interpreter, InputStream jythonStream) {
        try {
            interpreter.execfile(jythonStream);
        }
        finally {
            try {
                jythonStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to close jython stream " + jythonStream));
            }
        }
    }

    private static void setOption(Configuration conf, String key, Object value) {
        if (value instanceof Boolean) {
            conf.getBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            conf.setInt(key, ((Number)value).intValue());
        } else if (value instanceof Long) {
            conf.setLong(key, ((Long)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            conf.setFloat(key, ((Number)value).floatValue());
        } else if (value instanceof String) {
            conf.set(key, value.toString());
        } else if (value instanceof Class) {
            conf.set(key, ((Class)value).getName());
        } else {
            throw new IllegalArgumentException("Don't know how to handle option key: " + key + ", value: " + value + ", value type: " + value.getClass());
        }
    }

    public static String writeJythonJobToConf(JythonJob jythonJob, Configuration conf, PythonInterpreter interpreter) {
        HiveJythonUtils.checkJob(jythonJob);
        JythonUtils.init((Configuration)conf, (String)jythonJob.getComputation_name());
        if (jythonJob.getMessageCombiner() != null) {
            GiraphConstants.MESSAGE_COMBINER_CLASS.set(conf, jythonJob.getMessageCombiner());
        }
        conf.setInt("giraph.minWorkers", jythonJob.getWorkers());
        conf.setInt("giraph.maxWorkers", jythonJob.getWorkers());
        String javaOptions = Joiner.on((char)' ').join((Iterable)jythonJob.getJava_options());
        conf.set("mapred.child.java.opts", javaOptions);
        Map options = jythonJob.getGiraph_options();
        for (Map.Entry entry : options.entrySet()) {
            HiveJythonUtils.setOption(conf, (String)entry.getKey(), entry.getValue());
        }
        HiveJythonUtils.setPool(conf, jythonJob);
        HiveJythonUtils.initHiveReadersWriters(conf, jythonJob, interpreter);
        HiveJythonUtils.initGraphTypes(conf, jythonJob, interpreter);
        HiveJythonUtils.initOutput(conf, jythonJob);
        HiveJythonUtils.initVertexInputs(conf, jythonJob);
        HiveJythonUtils.initEdgeInputs(conf, jythonJob);
        String name = jythonJob.getName();
        if (name == null) {
            name = jythonJob.getComputation_name();
        }
        return name;
    }

    private static void setPool(Configuration conf, JythonJob job) {
        if (job.getPool() == null) {
            if (job.getWorkers() < 50) {
                job.setPool("graph.test");
            } else {
                job.setPool("graph.production");
            }
        }
        conf.set("mapred.fairscheduler.pool", job.getPool());
    }

    private static void checkJob(JythonJob jythonJob) {
        Preconditions.checkNotNull((Object)jythonJob.getComputation_name(), (Object)"computation_name cannot be null");
        HiveJythonUtils.checkTypeNotNull((JythonJob.TypeHolder)jythonJob.getVertex_id(), GraphType.VERTEX_ID);
        HiveJythonUtils.checkTypeNotNull((JythonJob.TypeHolder)jythonJob.getVertex_value(), GraphType.VERTEX_VALUE);
        HiveJythonUtils.checkTypeNotNull((JythonJob.TypeHolder)jythonJob.getEdge_value(), GraphType.EDGE_VALUE);
        HiveJythonUtils.checkMessageTypes(jythonJob);
    }

    private static boolean hasEdgeInputs(JythonJob jythonJob) {
        return !jythonJob.getEdge_inputs().isEmpty();
    }

    private static boolean hasVertexInputs(JythonJob jythonJob) {
        return !jythonJob.getVertex_inputs().isEmpty();
    }

    private static void checkTypeNotNull(JythonJob.TypeHolder typeHolder, GraphType graphType) {
        Preconditions.checkNotNull((Object)typeHolder.getType(), (Object)(graphType + ".type not present"));
    }

    private static void initGraphTypes(Configuration conf, JythonJob jythonJob, PythonInterpreter interpreter) {
        GiraphTypes types = new GiraphTypes();
        types.setVertexIdClass(HiveJythonUtils.initValueType(conf, GraphType.VERTEX_ID, jythonJob.getVertex_id().getType(), (JythonFactoryBase)new JythonVertexIdFactory(), interpreter));
        types.setVertexValueClass(HiveJythonUtils.initValueType(conf, GraphType.VERTEX_VALUE, jythonJob.getVertex_value().getType(), (JythonFactoryBase)new JythonVertexValueFactory(), interpreter));
        types.setEdgeValueClass(HiveJythonUtils.initValueType(conf, GraphType.EDGE_VALUE, jythonJob.getEdge_value().getType(), (JythonFactoryBase)new JythonEdgeValueFactory(), interpreter));
        types.setIncomingMessageValueClass(HiveJythonUtils.initValueType(conf, GraphType.INCOMING_MESSAGE_VALUE, jythonJob.getIncoming_message_value().getType(), (JythonFactoryBase)new JythonIncomingMessageValueFactory(), interpreter));
        types.setOutgoingMessageValueClass(HiveJythonUtils.initValueType(conf, GraphType.OUTGOING_MESSAGE_VALUE, jythonJob.getOutgoing_message_value().getType(), (JythonFactoryBase)new JythonOutgoingMessageValueFactory(), interpreter));
        types.writeTo(conf);
    }

    private static Class initValueType(Configuration conf, GraphType graphType, Object jythonOrJavaClass, JythonFactoryBase jythonFactory, PythonInterpreter interpreter) {
        Class writableClass = graphType.interfaceClass();
        LanguageAndType langType = HiveJythonUtils.processUserType(jythonOrJavaClass, interpreter);
        switch (langType.getLanguage()) {
            case JAVA: {
                GiraphConstants.GRAPH_TYPE_LANGUAGES.set(conf, graphType, (Enum)Language.JAVA);
                HiveJythonUtils.checkImplements(langType, writableClass, interpreter);
                return langType.getJavaClass();
            }
            case JYTHON: {
                GiraphConstants.GRAPH_TYPE_LANGUAGES.set(conf, graphType, (Enum)Language.JYTHON);
                String jythonClassName = langType.getJythonClassName();
                PyObject jythonClass = interpreter.get(jythonClassName);
                if (jythonClass == null) {
                    throw new IllegalArgumentException("Could not find Jython class " + jythonClassName + " for parameter " + graphType);
                }
                PyObject valuePyObj = jythonClass.__call__();
                Object pyWritable = valuePyObj.__tojava__(writableClass);
                if (pyWritable.equals(Py.NoConversion)) {
                    GiraphConstants.GRAPH_TYPES_NEEDS_WRAPPERS.set(conf, graphType, true);
                    jythonFactory.useThisFactory(conf, jythonClassName);
                    return JythonWritableWrapper.class;
                }
                GiraphConstants.GRAPH_TYPES_NEEDS_WRAPPERS.set(conf, graphType, false);
                jythonFactory.useThisFactory(conf, jythonClassName);
                return writableClass;
            }
        }
        throw new IllegalArgumentException("Don't know how to handle " + LanguageAndType.class.getSimpleName() + " with language " + langType.getLanguage());
    }

    private static void checkMessageTypes(JythonJob jythonJob) {
        HiveJythonUtils.checkMessageType(jythonJob.getIncoming_message_value(), GraphType.INCOMING_MESSAGE_VALUE, jythonJob);
        HiveJythonUtils.checkMessageType(jythonJob.getOutgoing_message_value(), GraphType.OUTGOING_MESSAGE_VALUE, jythonJob);
    }

    private static void checkMessageType(JythonJob.TypeHolder msgTypeHolder, GraphType graphType, JythonJob jythonJob) {
        if (msgTypeHolder.getType() == null) {
            Object msgValueType = jythonJob.getMessage_value().getType();
            Preconditions.checkNotNull((Object)msgValueType, (Object)(graphType + ".type and " + "message_value.type cannot both be empty"));
            msgTypeHolder.setType(msgValueType);
        }
    }

    private static void initHiveReadersWriters(Configuration conf, JythonJob jythonJob, PythonInterpreter interpreter) {
        if (!HiveJythonUtils.userTypeIsJavaPrimitiveWritable((JythonJob.TypeHolder)jythonJob.getVertex_id())) {
            HiveJythonUtils.checkTypeWithHive(jythonJob.getVertex_id(), GraphType.VERTEX_ID);
            LanguageAndType idReader = HiveJythonUtils.processUserType(jythonJob.getVertex_id().getHive_reader(), interpreter);
            HiveJythonUtils.checkImplements(idReader, JythonHiveReader.class, interpreter);
            Preconditions.checkArgument((idReader.getLanguage() == Language.JYTHON ? 1 : 0) != 0);
            GiraphHiveConstants.VERTEX_ID_READER_JYTHON_NAME.set(conf, idReader.getJythonClassName());
            LanguageAndType idWriter = HiveJythonUtils.processUserType(jythonJob.getVertex_id().getHive_writer(), interpreter);
            HiveJythonUtils.checkImplements(idWriter, JythonHiveWriter.class, interpreter);
            Preconditions.checkArgument((idWriter.getLanguage() == Language.JYTHON ? 1 : 0) != 0);
            GiraphHiveConstants.VERTEX_ID_WRITER_JYTHON_NAME.set(conf, idWriter.getJythonClassName());
        }
        if (HiveJythonUtils.hasVertexInputs(jythonJob) && !HiveJythonUtils.userTypeIsJavaPrimitiveWritable((JythonJob.TypeHolder)jythonJob.getVertex_value())) {
            HiveJythonUtils.checkTypeWithHive(jythonJob.getVertex_value(), GraphType.VERTEX_VALUE);
            LanguageAndType valueReader = HiveJythonUtils.processUserType(jythonJob.getVertex_value().getHive_reader(), interpreter);
            HiveJythonUtils.checkImplements(valueReader, JythonHiveReader.class, interpreter);
            Preconditions.checkArgument((valueReader.getLanguage() == Language.JYTHON ? 1 : 0) != 0);
            GiraphHiveConstants.VERTEX_VALUE_READER_JYTHON_NAME.set(conf, valueReader.getJythonClassName());
            LanguageAndType valueWriter = HiveJythonUtils.processUserType(jythonJob.getVertex_value().getHive_writer(), interpreter);
            HiveJythonUtils.checkImplements(valueWriter, JythonHiveWriter.class, interpreter);
            Preconditions.checkArgument((valueWriter.getLanguage() == Language.JYTHON ? 1 : 0) != 0);
            GiraphHiveConstants.VERTEX_VALUE_WRITER_JYTHON_NAME.set(conf, valueWriter.getJythonClassName());
        }
        if (HiveJythonUtils.hasEdgeInputs(jythonJob) && !HiveJythonUtils.userTypeIsJavaPrimitiveWritable((JythonJob.TypeHolder)jythonJob.getEdge_value())) {
            Preconditions.checkNotNull((Object)jythonJob.getEdge_value().getHive_reader(), (Object)"edge_value.hive_reader cannot be null");
            LanguageAndType edgeReader = HiveJythonUtils.processUserType(jythonJob.getEdge_value().getHive_reader(), interpreter);
            HiveJythonUtils.checkImplements(edgeReader, JythonHiveReader.class, interpreter);
            Preconditions.checkArgument((edgeReader.getLanguage() == Language.JYTHON ? 1 : 0) != 0);
            GiraphHiveConstants.EDGE_VALUE_READER_JYTHON_NAME.set(conf, edgeReader.getJythonClassName());
        }
    }

    private static LanguageAndType processUserType(Object valueFromUser, PythonInterpreter interpreter) {
        if (valueFromUser instanceof Class) {
            Class valueClass = (Class)valueFromUser;
            String jythonClassName = HiveJythonUtils.extractJythonClass(valueClass);
            if (jythonClassName != null) {
                return HiveJythonUtils.processJythonType(jythonClassName, interpreter);
            }
            return LanguageAndType.java(valueClass);
        }
        if (valueFromUser instanceof String) {
            String valueStr = (String)valueFromUser;
            try {
                Class<?> valueClass = Class.forName(valueStr);
                return LanguageAndType.java(valueClass);
            }
            catch (ClassNotFoundException e) {
                return HiveJythonUtils.processJythonType(valueStr, interpreter);
            }
        }
        if (valueFromUser instanceof PyClass) {
            PyClass userPyClass = (PyClass)valueFromUser;
            return HiveJythonUtils.processJythonType(userPyClass.__name__, interpreter);
        }
        if (valueFromUser instanceof PyType) {
            PyType userPyType = (PyType)valueFromUser;
            return HiveJythonUtils.processJythonType(userPyType.getName(), interpreter);
        }
        throw new IllegalArgumentException("Don't know how to handle " + valueFromUser + " of class " + valueFromUser.getClass() + ", needs to be Class or String");
    }

    private static void checkImplements(LanguageAndType langType, Class interfaceClass, PythonInterpreter interpreter) {
        switch (langType.getLanguage()) {
            case JAVA: {
                Preconditions.checkArgument((boolean)interfaceClass.isAssignableFrom(langType.getJavaClass()), (Object)(langType.getJavaClass().getSimpleName() + " needs to implement " + interfaceClass.getSimpleName()));
                break;
            }
            case JYTHON: {
                PyObject pyClass = interpreter.get(langType.getJythonClassName());
                PyObject pyObj = pyClass.__call__();
                Object converted = pyObj.__tojava__(interfaceClass);
                Preconditions.checkArgument((!Py.NoConversion.equals(converted) ? 1 : 0) != 0, (Object)("Jython class " + langType.getJythonClassName() + " does not implement " + interfaceClass.getSimpleName() + " interface"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to handle language " + langType.getLanguage());
            }
        }
    }

    private static LanguageAndType processJythonType(String jythonName, PythonInterpreter interpreter) {
        PyObject pyClass = interpreter.get(jythonName);
        Preconditions.checkNotNull((Object)pyClass, (Object)("Jython class " + jythonName + " not found"));
        return LanguageAndType.jython(jythonName);
    }

    private static void checkTypeWithHive(JythonJob.TypeWithHive typeWithHive, GraphType graphType) {
        if (typeWithHive.getHive_reader() == null) {
            Preconditions.checkNotNull((Object)typeWithHive.getHive_io(), (Object)(graphType + ".hive_reader and " + graphType + ".hive_io cannot both be empty"));
            typeWithHive.setHive_reader(typeWithHive.getHive_io());
        }
        if (typeWithHive.getHive_writer() == null) {
            Preconditions.checkNotNull((Object)typeWithHive.getHive_io(), (Object)(graphType + ".hive_writer and " + graphType + ".hive_io cannot both be empty"));
            typeWithHive.setHive_writer(typeWithHive.getHive_io());
        }
    }

    public static <T extends Writable> HiveValueReader<T> newValueReader(HiveTableSchema schema, StrConfOption columnOption, ImmutableClassesGiraphConfiguration conf, GraphType graphType, StrConfOption jythonClassNameOption) {
        HiveValueReader reader;
        if (HiveJythonUtils.isPrimitiveWritable(graphType.get(conf))) {
            reader = PrimitiveValueReader.create(conf, graphType, columnOption, schema);
        } else if (jythonClassNameOption.contains((Configuration)conf)) {
            reader = JythonColumnReader.create(conf, jythonClassNameOption, columnOption, schema);
        } else {
            throw new IllegalArgumentException("Don't know how to read " + graphType + " of class " + graphType.get(conf) + " which is not primitive and" + " no " + JythonHiveReader.class.getSimpleName() + " is set");
        }
        return reader;
    }

    public static <T extends Writable> HiveValueWriter<T> newValueWriter(HiveTableSchema schema, StrConfOption columnOption, ImmutableClassesGiraphConfiguration conf, GraphType graphType, StrConfOption jythonClassNameOption) {
        HiveValueWriter writer;
        if (HiveJythonUtils.isPrimitiveWritable(graphType.get(conf))) {
            writer = PrimitiveValueWriter.create(conf, columnOption, schema, graphType);
        } else if (jythonClassNameOption.contains((Configuration)conf)) {
            writer = JythonColumnWriter.create(conf, jythonClassNameOption, columnOption, schema);
        } else {
            throw new IllegalArgumentException("Don't know how to write " + graphType + " of class " + graphType.get(conf) + " which is not primitive and no " + JythonHiveWriter.class.getSimpleName() + " is set");
        }
        return writer;
    }

    private static String extractJythonClass(Class klass) {
        if (!HiveJythonUtils.isJythonClass(klass)) {
            return null;
        }
        Iterable parts = Splitter.on((char)'$').split((CharSequence)klass.getSimpleName());
        if (Iterables.size((Iterable)parts) != 3) {
            return null;
        }
        Iterator partsIter = parts.iterator();
        partsIter.next();
        return (String)partsIter.next();
    }

    private static boolean isJythonClass(Class klass) {
        return klass.getCanonicalName().startsWith("org.python.proxies");
    }

    private static void initEdgeInputs(Configuration conf, JythonJob jythonJob) {
        List edgeInputs = jythonJob.getEdge_inputs();
        if (!edgeInputs.isEmpty()) {
            if (edgeInputs.size() == 1) {
                GiraphConstants.EDGE_INPUT_FORMAT_CLASS.set(conf, HiveEdgeInputFormat.class);
                JythonJob.EdgeInput edgeInput = (JythonJob.EdgeInput)edgeInputs.get(0);
                HiveJythonUtils.checkEdgeInput(edgeInput);
                LOG.info((Object)("Setting edge input using: " + edgeInput));
                GiraphHiveConstants.HIVE_EDGE_INPUT.getDatabaseOpt().set(conf, jythonJob.getHive_database());
                GiraphHiveConstants.HIVE_EDGE_INPUT.getTableOpt().set(conf, edgeInput.getTable());
                if (edgeInput.getPartition_filter() != null) {
                    GiraphHiveConstants.HIVE_EDGE_INPUT.getPartitionOpt().set(conf, edgeInput.getPartition_filter());
                }
                GiraphHiveConstants.HIVE_EDGE_INPUT.getClassOpt().set(conf, JythonHiveToEdge.class);
                JythonHiveToEdge.EDGE_SOURCE_ID_COLUMN.set(conf, edgeInput.getSource_id_column());
                JythonHiveToEdge.EDGE_TARGET_ID_COLUMN.set(conf, edgeInput.getTarget_id_column());
                if (edgeInput.getValue_column() != null) {
                    JythonHiveToEdge.EDGE_VALUE_COLUMN.set(conf, edgeInput.getValue_column());
                }
            } else {
                GiraphConstants.EDGE_INPUT_FORMAT_CLASS.set(conf, MultiEdgeInputFormat.class);
                throw new IllegalArgumentException("Multiple edge inputs not supported yet: " + edgeInputs);
            }
        }
    }

    private static void checkEdgeInput(JythonJob.EdgeInput edgeInput) {
        Preconditions.checkNotNull((Object)edgeInput.getTable(), (Object)"EdgeInput table name needs to be set");
        Preconditions.checkNotNull((Object)edgeInput.getSource_id_column(), (Object)"EdgeInput source ID column needs to be set");
        Preconditions.checkNotNull((Object)edgeInput.getTarget_id_column(), (Object)"EdgeInput target ID column needs to be set");
    }

    private static void initVertexInputs(Configuration conf, JythonJob jythonJob) {
        List vertexInputs = jythonJob.getVertex_inputs();
        if (!vertexInputs.isEmpty()) {
            if (vertexInputs.size() == 1) {
                GiraphConstants.VERTEX_INPUT_FORMAT_CLASS.set(conf, HiveVertexInputFormat.class);
                JythonJob.VertexInput vertexInput = (JythonJob.VertexInput)vertexInputs.get(0);
                HiveJythonUtils.checkVertexInput(vertexInput);
                LOG.info((Object)("Setting vertex input using: " + vertexInput));
                GiraphHiveConstants.HIVE_VERTEX_INPUT.getDatabaseOpt().set(conf, jythonJob.getHive_database());
                GiraphHiveConstants.HIVE_VERTEX_INPUT.getTableOpt().set(conf, vertexInput.getTable());
                if (vertexInput.getPartition_filter() != null) {
                    GiraphHiveConstants.HIVE_VERTEX_INPUT.getPartitionOpt().set(conf, vertexInput.getPartition_filter());
                }
                GiraphHiveConstants.HIVE_VERTEX_INPUT.getClassOpt().set(conf, JythonHiveToVertex.class);
                JythonHiveToVertex.VERTEX_ID_COLUMN.set(conf, vertexInput.getId_column());
                if (vertexInput.getValue_column() != null) {
                    JythonHiveToVertex.VERTEX_VALUE_COLUMN.set(conf, vertexInput.getValue_column());
                }
            } else {
                GiraphConstants.VERTEX_INPUT_FORMAT_CLASS.set(conf, MultiVertexInputFormat.class);
                throw new IllegalArgumentException("Multiple vertex inputs not supported yet: " + vertexInputs);
            }
        }
    }

    private static void checkVertexInput(JythonJob.VertexInput vertexInput) {
        Preconditions.checkNotNull((Object)vertexInput.getTable(), (Object)"VertexInput table name needs to be set");
        Preconditions.checkNotNull((Object)vertexInput.getId_column(), (Object)"VertexInput ID column needs to be set");
    }

    public static boolean isPrimitiveWritable(Class klass) {
        return NullWritable.class.equals((Object)klass) || BooleanWritable.class.equals((Object)klass) || ByteWritable.class.equals((Object)klass) || IntWritable.class.equals((Object)klass) || LongWritable.class.equals((Object)klass) || FloatWritable.class.equals((Object)klass) || DoubleWritable.class.equals((Object)klass);
    }

    public static boolean userTypeIsJavaPrimitiveWritable(JythonJob.TypeHolder typeHolder) {
        Object type = typeHolder.getType();
        if (type instanceof Class) {
            return HiveJythonUtils.isPrimitiveWritable((Class)type);
        }
        if (type instanceof String) {
            try {
                Class<?> klass = Class.forName((String)type);
                return HiveJythonUtils.isPrimitiveWritable(klass);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private static void initOutput(Configuration conf, JythonJob jythonJob) {
        JythonJob.VertexOutput vertexOutput = jythonJob.getVertex_output();
        if (vertexOutput.getTable() != null) {
            LOG.info((Object)("Setting vertex output using: " + vertexOutput));
            GiraphConstants.VERTEX_OUTPUT_FORMAT_CLASS.set(conf, HiveVertexOutputFormat.class);
            GiraphHiveConstants.VERTEX_TO_HIVE_CLASS.set(conf, JythonVertexToHive.class);
            JythonVertexToHive.VERTEX_ID_COLUMN.set(conf, vertexOutput.getId_column());
            JythonVertexToHive.VERTEX_VALUE_COLUMN.set(conf, vertexOutput.getValue_column());
            GiraphHiveConstants.HIVE_VERTEX_OUTPUT_DATABASE.set(conf, jythonJob.getHive_database());
            GiraphHiveConstants.HIVE_VERTEX_OUTPUT_PROFILE_ID.set(conf, "vertex_output_profile");
            GiraphHiveConstants.HIVE_VERTEX_OUTPUT_TABLE.set(conf, vertexOutput.getTable());
            if (vertexOutput.getPartition() != null) {
                GiraphHiveConstants.HIVE_VERTEX_OUTPUT_PARTITION.set(conf, HiveJythonUtils.makePartitionString(vertexOutput.getPartition()));
            }
        }
    }

    private static String makePartitionString(Map<String, String> parts) {
        return Joiner.on((String)",").withKeyValueSeparator("=").join(parts);
    }
}

