/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.jython;

import com.facebook.hiveio.HiveIO;
import java.util.Arrays;
import org.apache.giraph.graph.Language;
import org.apache.giraph.hive.jython.HiveJythonUtils;
import org.apache.giraph.job.GiraphJob;
import org.apache.giraph.jython.JythonJob;
import org.apache.giraph.scripting.DeployType;
import org.apache.giraph.scripting.ScriptLoader;
import org.apache.giraph.utils.DistributedCacheUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import org.python.util.PythonInterpreter;

public class HiveJythonRunner
implements Tool {
    private static final Logger LOG = Logger.getLogger(HiveJythonRunner.class);
    private static HiveConf CONF = new HiveConf();

    public int run(String[] args) throws Exception {
        args = HiveJythonUtils.processArgs(args, (Configuration)CONF);
        LOG.info((Object)("Processed hive options now have args: " + Arrays.toString(args)));
        HiveIO.init((HiveConf)CONF, (boolean)false);
        PythonInterpreter interpreter = new PythonInterpreter();
        JythonJob jythonJob = HiveJythonUtils.parseJythonFiles(interpreter, args);
        HiveJythonRunner.logOptions();
        for (String arg : args) {
            Path remoteScriptPath = DistributedCacheUtils.copyAndAdd((Path)new Path(arg), (Configuration)CONF);
            ScriptLoader.addScriptToLoad((Configuration)CONF, (String)remoteScriptPath.toString(), (DeployType)DeployType.DISTRIBUTED_CACHE, (Language)Language.JYTHON);
        }
        String name = HiveJythonUtils.writeJythonJobToConf(jythonJob, (Configuration)CONF, interpreter);
        GiraphJob job = new GiraphJob((Configuration)CONF, name);
        return job.run(true) ? 0 : -1;
    }

    private static void logOptions() {
        StringBuilder sb = new StringBuilder(100);
        HiveJythonRunner.appendEnvVars(sb, "JAVA_HOME", "MAPRED_POOL_NAME");
        HiveJythonRunner.appendEnvVars(sb, "HADOOP_HOME", "HIVE_HOME");
        LOG.info((Object)("Environment:\n" + sb));
    }

    private static void appendEnvVars(StringBuilder sb, String ... names) {
        for (String name : names) {
            sb.append(name).append("=").append(System.getenv(name)).append("\n");
        }
    }

    public static void setStaticConf(Configuration conf) {
        CONF = conf instanceof HiveConf ? (HiveConf)conf : new HiveConf(conf, HiveJythonRunner.class);
    }

    public void setConf(Configuration conf) {
        HiveJythonRunner.setStaticConf(conf);
    }

    public Configuration getConf() {
        return CONF;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new HiveJythonRunner(), (String[])args));
    }
}

