/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.vertex.examples;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.parser.Records;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.hive.common.HiveParsing;
import org.apache.giraph.hive.input.vertex.SimpleHiveToVertex;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;

public class HiveIntDoubleDoubleVertex
extends SimpleHiveToVertex<IntWritable, DoubleWritable, DoubleWritable> {
    @Override
    public void checkInput(HiveInputDescription inputDesc, HiveTableSchema schema) {
        Records.verifyType((int)0, (HiveType)HiveType.INT, (HiveTableSchema)schema);
        Records.verifyType((int)1, (HiveType)HiveType.DOUBLE, (HiveTableSchema)schema);
        Records.verifyType((int)2, (HiveType)HiveType.MAP, (HiveTableSchema)schema);
    }

    @Override
    public Iterable<Edge<IntWritable, DoubleWritable>> getEdges(HiveReadableRecord record) {
        return HiveParsing.parseIntDoubleEdges(record, 2);
    }

    @Override
    public IntWritable getVertexId(HiveReadableRecord record) {
        return HiveParsing.parseIntID(record, 0, (IntWritable)this.getReusableVertexId());
    }

    @Override
    public DoubleWritable getVertexValue(HiveReadableRecord record) {
        return HiveParsing.parseDoubleWritable(record, 1, (DoubleWritable)this.getReusableVertexValue());
    }
}

