/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.vertex;

import com.facebook.hiveio.record.HiveReadableRecord;
import java.util.Iterator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.hive.input.vertex.AbstractHiveToVertex;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public abstract class SimpleHiveToVertex<I extends WritableComparable, V extends Writable, E extends Writable>
extends AbstractHiveToVertex<I, V, E> {
    private Iterator<HiveReadableRecord> records;
    private Vertex<I, V, E> reusableVertex;
    private I reusableVertexId;
    private V reusableVertexValue;
    private OutEdges<I, E> reusableOutEdges;

    public abstract I getVertexId(HiveReadableRecord var1);

    public abstract V getVertexValue(HiveReadableRecord var1);

    public abstract Iterable<Edge<I, E>> getEdges(HiveReadableRecord var1);

    @Override
    public void initializeRecords(Iterator<HiveReadableRecord> records) {
        this.records = records;
        this.reusableVertex = this.getConf().createVertex();
        this.reusableVertexId = this.getConf().createVertexId();
        this.reusableVertexValue = this.getConf().createVertexValue();
        this.reusableOutEdges = this.getConf().createOutEdges();
    }

    @Override
    public boolean hasNext() {
        return this.records.hasNext();
    }

    @Override
    public Vertex<I, V, E> next() {
        HiveReadableRecord record = this.records.next();
        I id = this.getVertexId(record);
        V value = this.getVertexValue(record);
        Iterable<Edge<I, E>> edges = this.getEdges(record);
        this.reusableVertex.initialize(id, value, edges);
        return this.reusableVertex;
    }

    protected I getReusableVertexId() {
        return this.reusableVertexId;
    }

    protected V getReusableVertexValue() {
        return this.reusableVertexValue;
    }

    protected <OE extends OutEdges<I, E>> OE getReusableOutEdges() {
        return (OE)this.reusableOutEdges;
    }
}

