/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.vertex;

import com.facebook.hiveio.record.HiveReadableRecord;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.hive.common.DefaultConfigurableAndTableSchemaAware;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.input.RecordReaderWrapper;
import org.apache.giraph.hive.input.vertex.HiveToVertex;
import org.apache.giraph.io.iterables.GiraphReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HiveVertexReader<I extends WritableComparable, V extends Writable, E extends Writable>
extends DefaultConfigurableAndTableSchemaAware<I, V, E>
implements GiraphReader<Vertex<I, V, E>> {
    private RecordReader<WritableComparable, HiveReadableRecord> hiveRecordReader;
    private HiveToVertex<I, V, E> hiveToVertex;

    public RecordReader<WritableComparable, HiveReadableRecord> getHiveRecordReader() {
        return this.hiveRecordReader;
    }

    public void setHiveRecordReader(RecordReader<WritableComparable, HiveReadableRecord> hiveRecordReader) {
        this.hiveRecordReader = hiveRecordReader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.hiveRecordReader.initialize(inputSplit, context);
        this.hiveToVertex = HiveUtils.newHiveToVertex(this.getConf(), this.getTableSchema());
        this.hiveToVertex.initializeRecords((Iterator<HiveReadableRecord>)((Object)new RecordReaderWrapper<HiveReadableRecord>(this.hiveRecordReader)));
    }

    public void close() throws IOException {
        this.hiveRecordReader.close();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.hiveRecordReader.getProgress();
    }

    public boolean hasNext() {
        return this.hiveToVertex.hasNext();
    }

    public Vertex<I, V, E> next() {
        return (Vertex)this.hiveToVertex.next();
    }

    public void remove() {
        this.hiveToVertex.remove();
    }
}

