/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.vertex;

import com.facebook.hiveio.input.HiveApiInputFormat;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.RecordReaderImpl;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.input.vertex.HiveToVertex;
import org.apache.giraph.hive.input.vertex.HiveVertexReader;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.iterables.VertexReaderWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HiveVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    private final HiveApiInputFormat hiveInputFormat = new HiveApiInputFormat();

    public void checkInputSpecs(Configuration conf) {
        HiveInputDescription inputDesc = GiraphHiveConstants.HIVE_VERTEX_INPUT.makeInputDescription(conf);
        HiveTableSchema schema = this.getTableSchema();
        HiveToVertex hiveToVertex = HiveUtils.newHiveToVertex(this.getConf(), schema);
        hiveToVertex.checkInput(inputDesc, schema);
    }

    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        super.setConf(conf);
        this.hiveInputFormat.initialize(GiraphHiveConstants.HIVE_VERTEX_INPUT.makeInputDescription((Configuration)conf), GiraphHiveConstants.HIVE_VERTEX_INPUT.getProfileID((Configuration)conf), conf);
    }

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.hiveInputFormat.getSplits(context);
    }

    public VertexReader<I, V, E> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        RecordReaderImpl baseReader;
        HiveVertexReader reader = new HiveVertexReader();
        reader.setTableSchema(this.getTableSchema());
        try {
            baseReader = this.hiveInputFormat.createRecordReader(split, context);
        }
        catch (InterruptedException e) {
            throw new IOException("Could not create vertex reader", e);
        }
        reader.setHiveRecordReader((RecordReader<WritableComparable, HiveReadableRecord>)baseReader);
        return new VertexReaderWrapper(reader);
    }

    private HiveTableSchema getTableSchema() {
        return this.hiveInputFormat.getTableSchema((Configuration)this.getConf());
    }
}

