/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.mapping.examples;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.parser.Records;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import java.util.Iterator;
import org.apache.giraph.hive.input.mapping.SimpleHiveToMapping;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;

public class LongInt2ByteHiveToMapping
extends SimpleHiveToMapping<LongWritable, ByteWritable> {
    private int numWorkers = 0;

    @Override
    public void initializeRecords(Iterator<HiveReadableRecord> records) {
        super.initializeRecords(records);
        this.numWorkers = this.getConf().getMaxWorkers();
        if (this.numWorkers <= 0 || this.numWorkers >= 255) {
            throw new IllegalStateException("#workers should be > 0 & < 255");
        }
    }

    @Override
    public void checkInput(HiveInputDescription inputDesc, HiveTableSchema schema) {
        Records.verifyType((int)0, (HiveType)HiveType.LONG, (HiveTableSchema)schema);
        Records.verifyType((int)1, (HiveType)HiveType.INT, (HiveTableSchema)schema);
    }

    @Override
    public LongWritable getVertexId(HiveReadableRecord record) {
        long id = record.getLong(0);
        LongWritable reusableId = (LongWritable)this.getReusableVertexId();
        reusableId.set(id);
        return reusableId;
    }

    @Override
    public ByteWritable getMappingTarget(HiveReadableRecord record) {
        int target = record.getInt(1);
        ByteWritable reusableTarget = (ByteWritable)this.getReusableMappingTarget();
        int bVal = target % this.numWorkers;
        if (bVal >>> 8 != 0) {
            throw new IllegalStateException("target % numWorkers overflows byte range");
        }
        reusableTarget.set((byte)bVal);
        return reusableTarget;
    }
}

