/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.mapping.examples;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.parser.Records;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import org.apache.giraph.hive.input.mapping.SimpleHiveToMapping;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;

public class LongByteHiveToMapping
extends SimpleHiveToMapping<LongWritable, ByteWritable> {
    @Override
    public void checkInput(HiveInputDescription inputDesc, HiveTableSchema schema) {
        Records.verifyType((int)0, (HiveType)HiveType.LONG, (HiveTableSchema)schema);
        Records.verifyType((int)1, (HiveType)HiveType.BYTE, (HiveTableSchema)schema);
    }

    @Override
    public LongWritable getVertexId(HiveReadableRecord record) {
        LongWritable reusableId = (LongWritable)this.getReusableVertexId();
        reusableId.set(record.getLong(0));
        return reusableId;
    }

    @Override
    public ByteWritable getMappingTarget(HiveReadableRecord record) {
        ByteWritable reusableTarget = (ByteWritable)this.getReusableMappingTarget();
        reusableTarget.set(record.getByte(1));
        return reusableTarget;
    }
}

