/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.mapping;

import com.facebook.hiveio.record.HiveReadableRecord;
import java.util.Iterator;
import org.apache.giraph.hive.input.mapping.AbstractHiveToMapping;
import org.apache.giraph.mapping.MappingEntry;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public abstract class SimpleHiveToMapping<I extends WritableComparable, B extends Writable>
extends AbstractHiveToMapping<I, B> {
    private Iterator<HiveReadableRecord> records;
    private MappingEntry<I, B> reusableEntry;
    private I reusableVertexId;
    private B reusableMappingTarget;

    public abstract I getVertexId(HiveReadableRecord var1);

    public abstract B getMappingTarget(HiveReadableRecord var1);

    @Override
    public void initializeRecords(Iterator<HiveReadableRecord> records) {
        this.records = records;
        this.reusableVertexId = this.getConf().createVertexId();
        this.reusableMappingTarget = this.getConf().createMappingTarget();
        this.reusableEntry = new MappingEntry(this.reusableVertexId, this.reusableMappingTarget);
    }

    @Override
    public boolean hasNext() {
        return this.records.hasNext();
    }

    @Override
    public MappingEntry<I, B> next() {
        HiveReadableRecord record = this.records.next();
        I id = this.getVertexId(record);
        B target = this.getMappingTarget(record);
        this.reusableEntry.setVertexId(id);
        this.reusableEntry.setMappingTarget(target);
        return this.reusableEntry;
    }

    public I getReusableVertexId() {
        return this.reusableVertexId;
    }

    public B getReusableMappingTarget() {
        return this.reusableMappingTarget;
    }
}

