/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.mapping;

import com.facebook.hiveio.record.HiveReadableRecord;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.hive.common.DefaultConfigurableAndTableSchemaAware;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.input.RecordReaderWrapper;
import org.apache.giraph.hive.input.mapping.HiveToMapping;
import org.apache.giraph.io.iterables.GiraphReader;
import org.apache.giraph.mapping.MappingEntry;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HiveMappingReader<I extends WritableComparable, B extends Writable>
extends DefaultConfigurableAndTableSchemaAware<I, Writable, Writable>
implements GiraphReader<MappingEntry<I, B>> {
    private RecordReader<WritableComparable, HiveReadableRecord> hiveRecordReader;
    private HiveToMapping<I, B> hiveToMapping;

    public RecordReader<WritableComparable, HiveReadableRecord> getHiveRecordReader() {
        return this.hiveRecordReader;
    }

    public void setHiveRecordReader(RecordReader<WritableComparable, HiveReadableRecord> hiveRecordReader) {
        this.hiveRecordReader = hiveRecordReader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.hiveRecordReader.initialize(inputSplit, context);
        this.hiveToMapping = HiveUtils.newHiveToMapping(this.getConf(), this.getTableSchema());
        this.hiveToMapping.initializeRecords((Iterator<HiveReadableRecord>)((Object)new RecordReaderWrapper<HiveReadableRecord>(this.hiveRecordReader)));
    }

    public void close() throws IOException {
        this.hiveRecordReader.close();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.hiveRecordReader.getProgress();
    }

    public boolean hasNext() {
        return this.hiveToMapping.hasNext();
    }

    public MappingEntry<I, B> next() {
        return (MappingEntry)this.hiveToMapping.next();
    }

    public void remove() {
        this.hiveToMapping.remove();
    }
}

