/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.mapping;

import com.facebook.hiveio.input.HiveApiInputFormat;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.RecordReaderImpl;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.input.mapping.HiveMappingReader;
import org.apache.giraph.hive.input.mapping.HiveToMapping;
import org.apache.giraph.io.MappingInputFormat;
import org.apache.giraph.io.MappingReader;
import org.apache.giraph.io.iterables.MappingReaderWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HiveMappingInputFormat<I extends WritableComparable, V extends Writable, E extends Writable, B extends Writable>
extends MappingInputFormat<I, V, E, B> {
    private final HiveApiInputFormat hiveInputFormat = new HiveApiInputFormat();

    public void checkInputSpecs(Configuration conf) {
        HiveInputDescription inputDesc = GiraphHiveConstants.HIVE_MAPPING_INPUT.makeInputDescription(conf);
        HiveTableSchema schema = this.getTableSchema();
        HiveToMapping hiveToMapping = HiveUtils.newHiveToMapping(this.getConf(), schema);
        hiveToMapping.checkInput(inputDesc, schema);
    }

    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        super.setConf(conf);
        this.hiveInputFormat.initialize(GiraphHiveConstants.HIVE_MAPPING_INPUT.makeInputDescription((Configuration)conf), GiraphHiveConstants.HIVE_MAPPING_INPUT.getProfileID((Configuration)conf), conf);
    }

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.hiveInputFormat.getSplits(context);
    }

    public MappingReader<I, V, E, B> createMappingReader(InputSplit split, TaskAttemptContext context) throws IOException {
        RecordReaderImpl baseReader;
        HiveMappingReader reader = new HiveMappingReader();
        reader.setTableSchema(this.getTableSchema());
        try {
            baseReader = this.hiveInputFormat.createRecordReader(split, context);
        }
        catch (InterruptedException e) {
            throw new IOException("Could not create map reader", e);
        }
        reader.setHiveRecordReader((RecordReader<WritableComparable, HiveReadableRecord>)baseReader);
        return new MappingReaderWrapper(reader);
    }

    private HiveTableSchema getTableSchema() {
        return this.hiveInputFormat.getTableSchema((Configuration)this.getConf());
    }
}

