/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.edge.examples;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.parser.Records;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import org.apache.giraph.hive.common.HiveParsing;
import org.apache.giraph.hive.input.edge.SimpleHiveToEdge;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.log4j.Logger;

public class HiveIntNullEdge
extends SimpleHiveToEdge<IntWritable, NullWritable> {
    private static final Logger LOG = Logger.getLogger(HiveIntNullEdge.class);

    @Override
    public void checkInput(HiveInputDescription inputDesc, HiveTableSchema schema) {
        Records.verifyType((int)0, (HiveType)HiveType.INT, (HiveTableSchema)schema);
        Records.verifyType((int)1, (HiveType)HiveType.INT, (HiveTableSchema)schema);
    }

    @Override
    public NullWritable getEdgeValue(HiveReadableRecord hiveRecord) {
        return NullWritable.get();
    }

    @Override
    public IntWritable getSourceVertexId(HiveReadableRecord hiveRecord) {
        return HiveParsing.parseIntID(hiveRecord, 0, (IntWritable)this.getReusableSourceVertexId());
    }

    @Override
    public IntWritable getTargetVertexId(HiveReadableRecord hiveRecord) {
        return HiveParsing.parseIntID(hiveRecord, 1, (IntWritable)this.getReusableTargetVertexId());
    }
}

