/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.edge.examples;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.parser.Records;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import org.apache.giraph.hive.common.HiveParsing;
import org.apache.giraph.hive.input.edge.SimpleHiveToEdge;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;

public class HiveIntDoubleEdge
extends SimpleHiveToEdge<IntWritable, DoubleWritable> {
    @Override
    public void checkInput(HiveInputDescription inputDesc, HiveTableSchema schema) {
        Records.verifyType((int)0, (HiveType)HiveType.INT, (HiveTableSchema)schema);
        Records.verifyType((int)1, (HiveType)HiveType.INT, (HiveTableSchema)schema);
        Records.verifyType((int)2, (HiveType)HiveType.DOUBLE, (HiveTableSchema)schema);
    }

    @Override
    public DoubleWritable getEdgeValue(HiveReadableRecord hiveRecord) {
        return HiveParsing.parseDoubleWritable(hiveRecord, 2, (DoubleWritable)this.getReusableEdgeValue());
    }

    @Override
    public IntWritable getSourceVertexId(HiveReadableRecord hiveRecord) {
        return HiveParsing.parseIntID(hiveRecord, 0, (IntWritable)this.getReusableSourceVertexId());
    }

    @Override
    public IntWritable getTargetVertexId(HiveReadableRecord hiveRecord) {
        return HiveParsing.parseIntID(hiveRecord, 1, (IntWritable)this.getReusableTargetVertexId());
    }
}

