/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.edge;

import com.facebook.hiveio.record.HiveReadableRecord;
import java.util.Iterator;
import org.apache.giraph.hive.input.edge.AbstractHiveToEdge;
import org.apache.giraph.io.iterables.EdgeWithSource;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public abstract class SimpleHiveToEdge<I extends WritableComparable, E extends Writable>
extends AbstractHiveToEdge<I, E> {
    private Iterator<HiveReadableRecord> records;
    private EdgeWithSource<I, E> reusableEdge = new EdgeWithSource();

    public abstract I getSourceVertexId(HiveReadableRecord var1);

    public abstract I getTargetVertexId(HiveReadableRecord var1);

    public abstract E getEdgeValue(HiveReadableRecord var1);

    @Override
    public void initializeRecords(Iterator<HiveReadableRecord> records) {
        this.records = records;
        this.reusableEdge.setSourceVertexId(this.getConf().createVertexId());
        this.reusableEdge.setEdge(this.getConf().createReusableEdge());
    }

    @Override
    public boolean hasNext() {
        return this.records.hasNext();
    }

    @Override
    public EdgeWithSource<I, E> next() {
        HiveReadableRecord record = this.records.next();
        this.reusableEdge.setSourceVertexId(this.getSourceVertexId(record));
        this.reusableEdge.setTargetVertexId(this.getTargetVertexId(record));
        this.reusableEdge.setEdgeValue(this.getEdgeValue(record));
        return this.reusableEdge;
    }

    protected I getReusableSourceVertexId() {
        return (I)this.reusableEdge.getSourceVertexId();
    }

    protected I getReusableTargetVertexId() {
        return (I)this.reusableEdge.getTargetVertexId();
    }

    protected E getReusableEdgeValue() {
        return (E)this.reusableEdge.getEdgeValue();
    }
}

