/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.edge;

import com.facebook.hiveio.record.HiveReadableRecord;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.hive.common.DefaultConfigurableAndTableSchemaAware;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.input.RecordReaderWrapper;
import org.apache.giraph.hive.input.edge.HiveToEdge;
import org.apache.giraph.io.iterables.EdgeWithSource;
import org.apache.giraph.io.iterables.GiraphReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HiveEdgeReader<I extends WritableComparable, E extends Writable>
extends DefaultConfigurableAndTableSchemaAware<I, Writable, E>
implements GiraphReader<EdgeWithSource<I, E>> {
    private RecordReader<WritableComparable, HiveReadableRecord> hiveRecordReader;
    private HiveToEdge<I, E> hiveToEdge;

    public RecordReader<WritableComparable, HiveReadableRecord> getHiveRecordReader() {
        return this.hiveRecordReader;
    }

    public void setHiveRecordReader(RecordReader<WritableComparable, HiveReadableRecord> hiveRecordReader) {
        this.hiveRecordReader = hiveRecordReader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.hiveRecordReader.initialize(inputSplit, context);
        this.hiveToEdge = HiveUtils.newHiveToEdge(this.getConf(), this.getTableSchema());
        this.hiveToEdge.initializeRecords((Iterator<HiveReadableRecord>)((Object)new RecordReaderWrapper<HiveReadableRecord>(this.hiveRecordReader)));
    }

    public void close() throws IOException {
        this.hiveRecordReader.close();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.hiveRecordReader.getProgress();
    }

    public boolean hasNext() {
        return this.hiveToEdge.hasNext();
    }

    public EdgeWithSource<I, E> next() {
        return (EdgeWithSource)this.hiveToEdge.next();
    }

    public void remove() {
        this.hiveToEdge.remove();
    }
}

