/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.input.edge;

import com.facebook.hiveio.input.HiveApiInputFormat;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.RecordReaderImpl;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.input.edge.HiveEdgeReader;
import org.apache.giraph.hive.input.edge.HiveToEdge;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.iterables.EdgeReaderWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HiveEdgeInputFormat<I extends WritableComparable, E extends Writable>
extends EdgeInputFormat<I, E> {
    private final HiveApiInputFormat hiveInputFormat = new HiveApiInputFormat();

    public void checkInputSpecs(Configuration conf) {
        HiveInputDescription inputDesc = GiraphHiveConstants.HIVE_VERTEX_INPUT.makeInputDescription(conf);
        HiveTableSchema schema = this.getTableSchema();
        HiveToEdge hiveToEdge = HiveUtils.newHiveToEdge(this.getConf(), schema);
        hiveToEdge.checkInput(inputDesc, schema);
    }

    public void setConf(ImmutableClassesGiraphConfiguration<I, Writable, E> conf) {
        super.setConf(conf);
        this.hiveInputFormat.initialize(GiraphHiveConstants.HIVE_EDGE_INPUT.makeInputDescription((Configuration)conf), GiraphHiveConstants.HIVE_EDGE_INPUT.getProfileID((Configuration)conf), conf);
    }

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.hiveInputFormat.getSplits(context);
    }

    public EdgeReader<I, E> createEdgeReader(InputSplit split, TaskAttemptContext context) throws IOException {
        RecordReaderImpl baseReader;
        HiveEdgeReader reader = new HiveEdgeReader();
        reader.setTableSchema(this.getTableSchema());
        try {
            baseReader = this.hiveInputFormat.createRecordReader(split, context);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Could not create edge record reader", e);
        }
        reader.setHiveRecordReader((RecordReader<WritableComparable, HiveReadableRecord>)baseReader);
        return new EdgeReaderWrapper(reader);
    }

    private HiveTableSchema getTableSchema() {
        return this.hiveInputFormat.getTableSchema((Configuration)this.getConf());
    }
}

