/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.common;

import org.apache.giraph.graph.Language;

public class LanguageAndType {
    private final Language language;
    private final Class javaClass;
    private final String jythonClassName;

    private LanguageAndType(Language language, Class javaClass, String jythonClassName) {
        this.javaClass = javaClass;
        this.language = language;
        this.jythonClassName = jythonClassName;
    }

    public static LanguageAndType jython(String name) {
        return new LanguageAndType(Language.JYTHON, null, name);
    }

    public static LanguageAndType java(Class klass) {
        return new LanguageAndType(Language.JAVA, klass, null);
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public String getJythonClassName() {
        return this.jythonClassName;
    }

    public Language getLanguage() {
        return this.language;
    }
}

