/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.common;

import com.facebook.hiveio.schema.HiveTableSchema;
import com.facebook.hiveio.schema.HiveTableSchemas;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.input.edge.HiveToEdge;
import org.apache.giraph.hive.input.mapping.HiveToMapping;
import org.apache.giraph.hive.input.vertex.HiveToVertex;
import org.apache.giraph.hive.output.VertexToHive;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class HiveUtils {
    private static final Logger LOG = Logger.getLogger(HiveUtils.class);

    private HiveUtils() {
    }

    public static Map<String, String> parsePartitionValues(String outputTablePartitionString) {
        if (outputTablePartitionString == null) {
            return null;
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        Splitter equalSplitter = Splitter.on((char)'=').omitEmptyStrings().trimResults();
        HashMap partitionValues = Maps.newHashMap();
        for (String keyValStr : commaSplitter.split((CharSequence)outputTablePartitionString)) {
            ArrayList keyVal = Lists.newArrayList((Iterable)equalSplitter.split((CharSequence)keyValStr));
            if (keyVal.size() != 2) {
                throw new IllegalArgumentException("Unrecognized partition value format: " + outputTablePartitionString);
            }
            partitionValues.put(keyVal.get(0), keyVal.get(1));
        }
        return partitionValues;
    }

    public static int columnIndexOrThrow(HiveTableSchema schema, String columnName) {
        int index = schema.positionOf(columnName);
        if (index == -1) {
            throw new IllegalArgumentException("Column " + columnName + " not found in table " + schema.getTableDesc());
        }
        return index;
    }

    public static int columnIndexOrThrow(HiveTableSchema schema, Configuration conf, StrConfOption confOption) {
        String columnName = confOption.get(conf);
        if (columnName == null) {
            throw new IllegalArgumentException("Column " + confOption.getKey() + " not set in configuration");
        }
        return HiveUtils.columnIndexOrThrow(schema, columnName);
    }

    public static void addHiveSiteXmlToTmpFiles(Configuration conf) {
        HiveUtils.addToHiveFromClassLoader(conf, "hive-site.xml");
    }

    public static void addHiveSiteCustomXmlToTmpFiles(Configuration conf) {
        HiveUtils.addToHiveFromClassLoader(conf, "hive-site-custom.xml");
        HiveUtils.addToHiveFromEnv(conf, "HIVE_HOME", "conf/hive-site.xml");
    }

    private static boolean addToHiveFromEnv(Configuration conf, String envKey, String path) {
        String envValue = System.getenv(envKey);
        if (envValue == null) {
            return false;
        }
        File file = new File(envValue, path);
        if (file.exists()) {
            LOG.info((Object)("addToHiveFromEnv: Adding " + file.getPath() + " to Configuration tmpfiles"));
        }
        try {
            HiveUtils.addToStringCollection(conf, "tmpfiles", file.toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Failed to get URL for file " + file));
        }
        return true;
    }

    private static boolean addToHiveFromClassLoader(Configuration conf, String name) {
        URL url = conf.getClassLoader().getResource(name);
        if (url == null) {
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("addToHiveFromClassLoader: Adding " + name + " at " + url + " to Configuration tmpfiles"));
        }
        HiveUtils.addToStringCollection(conf, "tmpfiles", url.toString());
        return true;
    }

    public static void addHadoopClasspathToTmpJars(Configuration conf) {
        String hadoopClasspath = System.getenv("HADOOP_CLASSPATH");
        if (hadoopClasspath == null) {
            return;
        }
        String[] hadoopJars = hadoopClasspath.split(File.pathSeparator);
        if (hadoopJars.length > 0) {
            ArrayList hadoopJarURLs = Lists.newArrayList();
            for (String jarPath : hadoopJars) {
                File file = new File(jarPath);
                if (!file.exists() || !file.isFile()) continue;
                hadoopJarURLs.add(file.toURI().toString());
            }
            HiveUtils.addToStringCollection(conf, "tmpjars", hadoopJarURLs);
        }
    }

    public static void processHiveconfOptions(String[] hiveconfArgs, Configuration conf) {
        for (String hiveconf : hiveconfArgs) {
            HiveUtils.processHiveconfOption(conf, hiveconf);
        }
    }

    public static void processHiveconfOption(Configuration conf, String hiveconf) {
        String[] keyval = hiveconf.split("=", 2);
        if (keyval.length == 2) {
            String name = keyval[0];
            String value = keyval[1];
            if (name.equals("tmpjars") || name.equals("tmpfiles")) {
                HiveUtils.addToStringCollection(conf, name, value);
            } else {
                conf.set(name, value);
            }
        }
    }

    public static void addToStringCollection(Configuration conf, String key, String ... values) {
        HiveUtils.addToStringCollection(conf, key, Arrays.asList(values));
    }

    public static void addToStringCollection(Configuration conf, String key, Collection<String> values) {
        Collection strings = conf.getStringCollection(key);
        strings.addAll(values);
        conf.setStrings(key, strings.toArray(new String[strings.size()]));
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> VertexToHive<I, V, E> newVertexToHive(ImmutableClassesGiraphConfiguration<I, V, E> conf, HiveTableSchema schema) throws IOException {
        Class klass = GiraphHiveConstants.VERTEX_TO_HIVE_CLASS.get(conf);
        if (klass == null) {
            throw new IOException(GiraphHiveConstants.VERTEX_TO_HIVE_CLASS.getKey() + " not set in conf");
        }
        return (VertexToHive)HiveUtils.newInstance(klass, conf, schema);
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> HiveToEdge<I, E> newHiveToEdge(ImmutableClassesGiraphConfiguration<I, V, E> conf, HiveTableSchema schema) {
        Class<HiveToEdge> klass = GiraphHiveConstants.HIVE_EDGE_INPUT.getClass((Configuration)conf);
        if (klass == null) {
            throw new IllegalArgumentException(GiraphHiveConstants.HIVE_EDGE_INPUT.getClassOpt().getKey() + " not set in conf");
        }
        return HiveUtils.newInstance(klass, conf, schema);
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> HiveToVertex<I, V, E> newHiveToVertex(ImmutableClassesGiraphConfiguration<I, V, E> conf, HiveTableSchema schema) {
        Class<HiveToVertex> klass = GiraphHiveConstants.HIVE_VERTEX_INPUT.getClass((Configuration)conf);
        if (klass == null) {
            throw new IllegalArgumentException(GiraphHiveConstants.HIVE_VERTEX_INPUT.getClassOpt().getKey() + " not set in conf");
        }
        return HiveUtils.newInstance(klass, conf, schema);
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable, B extends Writable> HiveToMapping<I, B> newHiveToMapping(ImmutableClassesGiraphConfiguration<I, V, E> conf, HiveTableSchema schema) {
        Class<HiveToMapping> klass = GiraphHiveConstants.HIVE_MAPPING_INPUT.getClass((Configuration)conf);
        if (klass == null) {
            throw new IllegalArgumentException(GiraphHiveConstants.HIVE_MAPPING_INPUT.getClassOpt().getKey() + " not set in conf");
        }
        return HiveUtils.newInstance(klass, conf, schema);
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable, T> T newInstance(Class<T> klass, ImmutableClassesGiraphConfiguration<I, V, E> conf, HiveTableSchema schema) {
        Object object = ReflectionUtils.newInstance(klass, conf);
        HiveTableSchemas.configure((Object)object, (HiveTableSchema)schema);
        return (T)object;
    }
}

