/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.common;

import com.facebook.hiveio.record.HiveReadableRecord;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class HiveParsing {
    private HiveParsing() {
    }

    public static byte parseByte(HiveReadableRecord record, int columnIndex) {
        return record.getByte(columnIndex);
    }

    public static int parseInt(HiveReadableRecord record, int columnIndex) {
        return record.getInt(columnIndex);
    }

    public static IntWritable parseIntID(HiveReadableRecord record, int columnIndex, IntWritable reusableId) {
        reusableId.set(HiveParsing.parseInt(record, columnIndex));
        return reusableId;
    }

    public static LongWritable parseLongID(HiveReadableRecord record, int columnIndex, LongWritable reusableId) {
        reusableId.set(record.getLong(columnIndex));
        return reusableId;
    }

    public static DoubleWritable parseDoubleWritable(HiveReadableRecord record, int columnIndex, DoubleWritable reusableDoubleWritable) {
        reusableDoubleWritable.set(record.getDouble(columnIndex));
        return reusableDoubleWritable;
    }

    public static Iterable<Edge<IntWritable, DoubleWritable>> parseIntDoubleEdges(HiveReadableRecord record, int columnIndex) {
        Object edgesObj = record.get(columnIndex);
        if (edgesObj == null) {
            return ImmutableList.of();
        }
        Map readEdges = (Map)edgesObj;
        ArrayList edges = Lists.newArrayListWithCapacity((int)readEdges.size());
        for (Map.Entry entry : readEdges.entrySet()) {
            edges.add(EdgeFactory.create((WritableComparable)new IntWritable(((Long)entry.getKey()).intValue()), (Writable)new DoubleWritable(((Double)entry.getValue()).doubleValue())));
        }
        return edges;
    }

    public static Iterable<Edge<IntWritable, NullWritable>> parseIntNullEdges(HiveReadableRecord record, int index) {
        List ids = (List)record.get(index);
        if (ids == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator i$ = ids.iterator();
        while (i$.hasNext()) {
            long id = (Long)i$.next();
            builder.add((Object)EdgeFactory.create((WritableComparable)new IntWritable((int)id)));
        }
        return builder.build();
    }

    public static Iterable<Edge<LongWritable, DoubleWritable>> parseLongDoubleEdges(HiveReadableRecord record, int columnIndex) {
        Object edgesObj = record.get(columnIndex);
        if (edgesObj == null) {
            return ImmutableList.of();
        }
        Map readEdges = (Map)edgesObj;
        ArrayList edges = Lists.newArrayListWithCapacity((int)readEdges.size());
        for (Map.Entry entry : readEdges.entrySet()) {
            edges.add(EdgeFactory.create((WritableComparable)new LongWritable(((Long)entry.getKey()).longValue()), (Writable)new DoubleWritable(((Double)entry.getValue()).doubleValue())));
        }
        return edges;
    }
}

