/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive.common;

import com.facebook.hiveio.input.HiveInputDescription;
import org.apache.giraph.conf.ClassConfOption;
import org.apache.giraph.conf.IntConfOption;
import org.apache.giraph.conf.StrConfOption;
import org.apache.hadoop.conf.Configuration;

public class HiveInputOptions<C> {
    private final ClassConfOption<C> classOpt;
    private final StrConfOption profileIdOpt;
    private final IntConfOption splitsOpt;
    private final StrConfOption databaseOpt;
    private final StrConfOption tableOpt;
    private final StrConfOption partitionOpt;
    private final StrConfOption hostOpt;
    private final IntConfOption portOpt;

    public HiveInputOptions(String name, Class<C> hiveToTypeClass) {
        this.classOpt = ClassConfOption.create((String)HiveInputOptions.key(name, "class"), null, hiveToTypeClass, (String)"Class for converting hive records");
        this.profileIdOpt = new StrConfOption(HiveInputOptions.key(name, "profileId"), name + "_input_profile", "Input profile id");
        this.partitionOpt = new StrConfOption(HiveInputOptions.key(name, "partition"), "", "Input partition filter");
        this.splitsOpt = new IntConfOption(HiveInputOptions.key(name, "splits"), 0, "Number of splits");
        this.databaseOpt = new StrConfOption(HiveInputOptions.key(name, "database"), "default", "Input database name");
        this.tableOpt = new StrConfOption(HiveInputOptions.key(name, "table"), "", "Input table name");
        this.hostOpt = new StrConfOption(HiveInputOptions.key(name, "metastore.host"), null, "Hive Metastore host to use. If blank will infer from HiveConf");
        this.portOpt = new IntConfOption(HiveInputOptions.key(name, "metastore.port"), 9083, "Hive Metastore port to use.");
    }

    private static String key(String name, String suffix) {
        return "giraph.hive.input." + name + "." + suffix;
    }

    public String getProfileID(Configuration conf) {
        return this.profileIdOpt.get(conf);
    }

    public void setClass(Configuration conf, Class<? extends C> hiveToTypeClass) {
        this.classOpt.set(conf, hiveToTypeClass);
    }

    public void setDatabase(Configuration conf, String dbName) {
        this.databaseOpt.set(conf, dbName);
    }

    public void setTable(Configuration conf, String tableName) {
        this.tableOpt.set(conf, tableName);
    }

    public void setPartition(Configuration conf, String partitionFilter) {
        this.partitionOpt.set(conf, partitionFilter);
    }

    public Class<? extends C> getClass(Configuration conf) {
        return this.classOpt.get(conf);
    }

    public StrConfOption getDatabaseOpt() {
        return this.databaseOpt;
    }

    public StrConfOption getHostOpt() {
        return this.hostOpt;
    }

    public ClassConfOption<C> getClassOpt() {
        return this.classOpt;
    }

    public StrConfOption getPartitionOpt() {
        return this.partitionOpt;
    }

    public IntConfOption getPortOpt() {
        return this.portOpt;
    }

    public StrConfOption getProfileIdOpt() {
        return this.profileIdOpt;
    }

    public IntConfOption getSplitsOpt() {
        return this.splitsOpt;
    }

    public StrConfOption getTableOpt() {
        return this.tableOpt;
    }

    public HiveInputDescription makeInputDescription(Configuration conf) {
        HiveInputDescription inputDescription = new HiveInputDescription();
        inputDescription.getTableDesc().setDatabaseName(this.databaseOpt.get(conf));
        inputDescription.getTableDesc().setTableName(this.tableOpt.get(conf));
        inputDescription.setPartitionFilter(this.partitionOpt.get(conf));
        inputDescription.setNumSplits(this.splitsOpt.get(conf));
        inputDescription.getMetastoreDesc().setHost(this.hostOpt.get(conf));
        inputDescription.getMetastoreDesc().setPort(this.portOpt.get(conf));
        return inputDescription;
    }
}

