/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.hive;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.hive.common.GiraphHiveConstants;
import org.apache.giraph.hive.common.HiveUtils;
import org.apache.giraph.hive.input.edge.HiveEdgeInputFormat;
import org.apache.giraph.hive.input.edge.HiveToEdge;
import org.apache.giraph.hive.input.mapping.HiveMappingInputFormat;
import org.apache.giraph.hive.input.mapping.HiveToMapping;
import org.apache.giraph.hive.input.vertex.HiveToVertex;
import org.apache.giraph.hive.input.vertex.HiveVertexInputFormat;
import org.apache.giraph.hive.output.HiveVertexOutputFormat;
import org.apache.giraph.hive.output.VertexToHive;
import org.apache.giraph.io.formats.multi.EdgeInputFormatDescription;
import org.apache.giraph.io.formats.multi.InputFormatDescription;
import org.apache.giraph.io.formats.multi.MultiEdgeInputFormat;
import org.apache.giraph.io.formats.multi.MultiVertexInputFormat;
import org.apache.giraph.io.formats.multi.VertexInputFormatDescription;
import org.apache.giraph.job.GiraphJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class HiveGiraphRunner
implements Tool {
    private static final Logger LOG = Logger.getLogger(HiveGiraphRunner.class);
    private static final String LOG_PREFIX = "\t";
    protected int workers;
    protected boolean isVerbose;
    private Class<? extends Computation> computationClass;
    private List<VertexInputFormatDescription> vertexInputDescriptions = Lists.newArrayList();
    private List<EdgeInputFormatDescription> edgeInputDescriptions = Lists.newArrayList();
    private Class<? extends HiveToMapping> hiveToMappingClass;
    private Class<? extends VertexToHive> vertexToHiveClass;
    private boolean skipOutput = false;
    private Configuration conf = new HiveConf(this.getClass());

    public Class<? extends Computation> getComputationClass() {
        return this.computationClass;
    }

    public void setComputationClass(Class<? extends Computation> computationClass) {
        this.computationClass = computationClass;
    }

    public List<VertexInputFormatDescription> getVertexInputDescriptions() {
        return this.vertexInputDescriptions;
    }

    public boolean hasVertexInput() {
        return !this.vertexInputDescriptions.isEmpty();
    }

    public void addVertexInput(Class<? extends HiveToVertex> hiveToVertexClass, String tableName, String partitionFilter, String ... additionalOptions) {
        VertexInputFormatDescription description = new VertexInputFormatDescription(HiveVertexInputFormat.class);
        description.addParameter(GiraphHiveConstants.HIVE_VERTEX_INPUT.getClassOpt().getKey(), hiveToVertexClass.getName());
        description.addParameter(GiraphHiveConstants.HIVE_VERTEX_INPUT.getProfileIdOpt().getKey(), "vertex_input_profile_" + this.vertexInputDescriptions.size());
        description.addParameter(GiraphHiveConstants.HIVE_VERTEX_INPUT.getTableOpt().getKey(), tableName);
        if (partitionFilter != null && !partitionFilter.isEmpty()) {
            description.addParameter(GiraphHiveConstants.HIVE_VERTEX_INPUT.getPartitionOpt().getKey(), partitionFilter);
        }
        HiveGiraphRunner.addAdditionalOptions((InputFormatDescription)description, additionalOptions);
        this.vertexInputDescriptions.add(description);
    }

    public List<EdgeInputFormatDescription> getEdgeInputDescriptions() {
        return this.edgeInputDescriptions;
    }

    public boolean hasEdgeInput() {
        return !this.edgeInputDescriptions.isEmpty();
    }

    public void addEdgeInput(Class<? extends HiveToEdge> hiveToEdgeClass, String tableName, String partitionFilter, String ... additionalOptions) {
        EdgeInputFormatDescription description = new EdgeInputFormatDescription(HiveEdgeInputFormat.class);
        description.addParameter(GiraphHiveConstants.HIVE_EDGE_INPUT.getClassOpt().getKey(), hiveToEdgeClass.getName());
        description.addParameter(GiraphHiveConstants.HIVE_EDGE_INPUT.getProfileIdOpt().getKey(), "edge_input_profile_" + this.edgeInputDescriptions.size());
        description.addParameter(GiraphHiveConstants.HIVE_EDGE_INPUT.getTableOpt().getKey(), tableName);
        if (partitionFilter != null && !partitionFilter.isEmpty()) {
            description.addParameter(GiraphHiveConstants.HIVE_EDGE_INPUT.getPartitionOpt().getKey(), partitionFilter);
        }
        HiveGiraphRunner.addAdditionalOptions((InputFormatDescription)description, additionalOptions);
        this.edgeInputDescriptions.add(description);
    }

    private static void addAdditionalOptions(InputFormatDescription description, String ... additionalOptions) {
        for (String additionalOption : additionalOptions) {
            String[] nameValue = HiveGiraphRunner.split(additionalOption, "=");
            if (nameValue.length != 2) {
                throw new IllegalStateException("Invalid additional option format " + additionalOption + ", 'name=value' format expected");
            }
            description.addParameter(nameValue[0], nameValue[1]);
        }
    }

    public Class<? extends VertexToHive> getVertexToHiveClass() {
        return this.vertexToHiveClass;
    }

    public boolean hasVertexOutput() {
        return !this.skipOutput && this.vertexToHiveClass != null;
    }

    public void setVertexOutput(Class<? extends VertexToHive> vertexToHiveClass, String tableName, String partitionFilter) {
        this.vertexToHiveClass = vertexToHiveClass;
        GiraphHiveConstants.VERTEX_TO_HIVE_CLASS.set(this.conf, vertexToHiveClass);
        GiraphHiveConstants.HIVE_VERTEX_OUTPUT_PROFILE_ID.set(this.conf, "vertex_output_profile");
        GiraphHiveConstants.HIVE_VERTEX_OUTPUT_TABLE.set(this.conf, tableName);
        if (partitionFilter != null) {
            GiraphHiveConstants.HIVE_VERTEX_OUTPUT_PARTITION.set(this.conf, partitionFilter);
        }
    }

    public boolean hasMappingInput() {
        return this.hiveToMappingClass != null;
    }

    public void setMappingInput(Class<? extends HiveToMapping> hiveToMappingClass, String tableName, String partitionFilter) {
        this.hiveToMappingClass = hiveToMappingClass;
        this.conf.set(GiraphHiveConstants.HIVE_MAPPING_INPUT.getClassOpt().getKey(), hiveToMappingClass.getName());
        this.conf.set(GiraphHiveConstants.HIVE_MAPPING_INPUT.getProfileIdOpt().getKey(), "mapping_input_profile");
        this.conf.set(GiraphHiveConstants.HIVE_MAPPING_INPUT.getTableOpt().getKey(), tableName);
        if (partitionFilter != null) {
            this.conf.set(GiraphHiveConstants.HIVE_MAPPING_INPUT.getPartitionOpt().getKey(), partitionFilter);
        }
    }

    public static void main(String[] args) throws Exception {
        HiveGiraphRunner runner = new HiveGiraphRunner();
        System.exit(ToolRunner.run((Tool)runner, (String[])args));
    }

    public final int run(String[] args) throws Exception {
        try {
            this.handleCommandLine(args);
        }
        catch (InterruptedException e) {
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return -1;
        }
        HiveUtils.addHadoopClasspathToTmpJars(this.conf);
        HiveUtils.addHiveSiteXmlToTmpFiles(this.conf);
        GiraphJob job = new GiraphJob(this.getConf(), this.getClass().getName());
        GiraphConfiguration giraphConf = job.getConfiguration();
        giraphConf.setComputationClass(this.computationClass);
        giraphConf.setWorkerConfiguration(this.workers, this.workers, 100.0f);
        this.initGiraphJob(job);
        this.logOptions(giraphConf);
        return job.run(this.isVerbose) ? 0 : -1;
    }

    private ImmutableClassesGiraphConfiguration createGiraphConf(final Configuration conf) {
        return new ImmutableClassesGiraphConfiguration(conf){

            public void set(String name, String value) {
                super.set(name, value);
                conf.set(name, value);
            }
        };
    }

    private ImmutableClassesGiraphConfiguration createGiraphConf(Configuration conf, final InputFormatDescription inputFormatDescription) {
        return new ImmutableClassesGiraphConfiguration(conf){

            public void set(String name, String value) {
                super.set(name, value);
                inputFormatDescription.addParameter(name, value);
            }
        };
    }

    public void prepareHiveVertexInputs() {
        if (this.vertexInputDescriptions.size() == 1) {
            GiraphConstants.VERTEX_INPUT_FORMAT_CLASS.set(this.conf, this.vertexInputDescriptions.get(0).getInputFormatClass());
            this.vertexInputDescriptions.get(0).putParametersToConfiguration(this.conf);
            this.createGiraphConf(this.conf).createWrappedVertexInputFormat().checkInputSpecs(this.conf);
        } else {
            for (int i = 0; i < this.vertexInputDescriptions.size(); ++i) {
                Configuration confCopy = new Configuration(this.conf);
                VertexInputFormatDescription vertexInputDescription = this.vertexInputDescriptions.get(i);
                GiraphConstants.VERTEX_INPUT_FORMAT_CLASS.set(confCopy, vertexInputDescription.getInputFormatClass());
                vertexInputDescription.putParametersToConfiguration(confCopy);
                this.createGiraphConf(confCopy, (InputFormatDescription)vertexInputDescription).createWrappedVertexInputFormat().checkInputSpecs(confCopy);
            }
            GiraphConstants.VERTEX_INPUT_FORMAT_CLASS.set(this.conf, MultiVertexInputFormat.class);
            VertexInputFormatDescription.VERTEX_INPUT_FORMAT_DESCRIPTIONS.set(this.conf, InputFormatDescription.toJsonString(this.vertexInputDescriptions));
        }
    }

    public void prepareHiveEdgeInputs() {
        if (this.edgeInputDescriptions.size() == 1) {
            GiraphConstants.EDGE_INPUT_FORMAT_CLASS.set(this.conf, this.edgeInputDescriptions.get(0).getInputFormatClass());
            this.edgeInputDescriptions.get(0).putParametersToConfiguration(this.conf);
            this.createGiraphConf(this.conf).createWrappedEdgeInputFormat().checkInputSpecs(this.conf);
        } else {
            for (int i = 0; i < this.edgeInputDescriptions.size(); ++i) {
                Configuration confCopy = new Configuration(this.conf);
                EdgeInputFormatDescription edgeInputDescription = this.edgeInputDescriptions.get(i);
                GiraphConstants.EDGE_INPUT_FORMAT_CLASS.set(confCopy, edgeInputDescription.getInputFormatClass());
                edgeInputDescription.putParametersToConfiguration(confCopy);
                this.createGiraphConf(confCopy, (InputFormatDescription)edgeInputDescription).createWrappedEdgeInputFormat().checkInputSpecs(confCopy);
            }
            GiraphConstants.EDGE_INPUT_FORMAT_CLASS.set(this.conf, MultiEdgeInputFormat.class);
            EdgeInputFormatDescription.EDGE_INPUT_FORMAT_DESCRIPTIONS.set(this.conf, InputFormatDescription.toJsonString(this.edgeInputDescriptions));
        }
    }

    public void prepareHiveOutput() {
        GiraphConstants.VERTEX_OUTPUT_FORMAT_CLASS.set(this.conf, HiveVertexOutputFormat.class);
        this.createGiraphConf(this.conf).createWrappedVertexOutputFormat();
    }

    public void prepareHiveMappingInput() {
        GiraphConstants.MAPPING_INPUT_FORMAT_CLASS.set(this.conf, HiveMappingInputFormat.class);
        Configuration confCopy = new Configuration(this.conf);
        this.createGiraphConf(confCopy).createWrappedMappingInputFormat().checkInputSpecs(confCopy);
    }

    private CommandLine handleCommandLine(String[] args) throws ParseException, InterruptedException {
        String output;
        String[] edgeInputs;
        String[] vertexInputs;
        Options options = new Options();
        this.addOptions(options);
        this.addMoreOptions(options);
        GnuParser parser = new GnuParser();
        CommandLine cmdln = parser.parse(options, args);
        if (args.length == 0 || cmdln.hasOption("help")) {
            new HelpFormatter().printHelp(this.getClass().getName(), options, true);
            throw new InterruptedException();
        }
        HiveUtils.processHiveconfOptions(cmdln.getOptionValues("hiveconf"), this.conf);
        String computationClassStr = cmdln.getOptionValue("computationClass");
        if (computationClassStr != null) {
            this.computationClass = this.findClass(computationClassStr, Computation.class);
        }
        if (this.computationClass == null) {
            throw new IllegalArgumentException("Need the Giraph " + Computation.class.getSimpleName() + " class name (-computationClass) to use");
        }
        String mappingInput = cmdln.getOptionValue("mappingInput");
        if (mappingInput != null) {
            String[] parameters = HiveGiraphRunner.split(mappingInput, ",", 3);
            if (parameters.length < 2) {
                throw new IllegalStateException("Illegal mappingInput description " + mappingInput + " - HiveToMapping class and table name needed");
            }
            this.setMappingInput(this.findClass(parameters[0], HiveToMapping.class), parameters[1], HiveGiraphRunner.elementOrNull(parameters, 2));
        }
        if ((vertexInputs = cmdln.getOptionValues("vertexInput")) != null && vertexInputs.length != 0) {
            this.vertexInputDescriptions.clear();
            for (String vertexInput : vertexInputs) {
                String[] parameters = HiveGiraphRunner.split(vertexInput, ",");
                if (parameters.length < 2) {
                    throw new IllegalStateException("Illegal vertex input description " + vertexInput + " - HiveToVertex class and table name needed");
                }
                this.addVertexInput(this.findClass(parameters[0], HiveToVertex.class), parameters[1], HiveGiraphRunner.elementOrNull(parameters, 2), HiveGiraphRunner.copyOfArray(parameters, 3));
            }
        }
        if ((edgeInputs = cmdln.getOptionValues("edgeInput")) != null && edgeInputs.length != 0) {
            this.edgeInputDescriptions.clear();
            for (String edgeInput : edgeInputs) {
                String[] parameters = HiveGiraphRunner.split(edgeInput, ",");
                if (parameters.length < 2) {
                    throw new IllegalStateException("Illegal edge input description " + edgeInput + " - HiveToEdge class and table name needed");
                }
                this.addEdgeInput(this.findClass(parameters[0], HiveToEdge.class), parameters[1], HiveGiraphRunner.elementOrNull(parameters, 2), HiveGiraphRunner.copyOfArray(parameters, 3));
            }
        }
        if ((output = cmdln.getOptionValue("output")) != null) {
            String[] parameters = HiveGiraphRunner.split(output, ",", 3);
            if (parameters.length < 2) {
                throw new IllegalStateException("Illegal output description " + output + " - VertexToHive class and table name needed");
            }
            this.setVertexOutput(this.findClass(parameters[0], VertexToHive.class), parameters[1], HiveGiraphRunner.elementOrNull(parameters, 2));
        }
        if (cmdln.hasOption("skipOutput")) {
            this.skipOutput = true;
        }
        if (!this.hasVertexInput() && !this.hasEdgeInput()) {
            throw new IllegalArgumentException("Need at least one of Giraph " + HiveToVertex.class.getSimpleName() + " (-vertexInput) and " + HiveToEdge.class.getSimpleName() + " (-edgeInput)");
        }
        if (this.vertexToHiveClass == null && !this.skipOutput) {
            throw new IllegalArgumentException("Need the Giraph " + VertexToHive.class.getSimpleName() + " (-output) to use");
        }
        String workersStr = cmdln.getOptionValue("workers");
        if (workersStr == null) {
            throw new IllegalArgumentException("Need to choose the number of workers (-w)");
        }
        String dbName = cmdln.getOptionValue("dbName", "default");
        this.workers = Integer.parseInt(workersStr);
        this.isVerbose = cmdln.hasOption("verbose");
        this.processMoreArguments(cmdln);
        if (mappingInput != null) {
            GiraphHiveConstants.HIVE_MAPPING_INPUT.getDatabaseOpt().set(this.conf, dbName);
            this.prepareHiveMappingInput();
        }
        if (this.hasVertexInput()) {
            GiraphHiveConstants.HIVE_VERTEX_INPUT.getDatabaseOpt().set(this.conf, dbName);
            this.prepareHiveVertexInputs();
        }
        if (this.hasEdgeInput()) {
            GiraphHiveConstants.HIVE_EDGE_INPUT.getDatabaseOpt().set(this.conf, dbName);
            this.prepareHiveEdgeInputs();
        }
        if (!this.skipOutput) {
            GiraphHiveConstants.HIVE_VERTEX_OUTPUT_DATABASE.set(this.conf, dbName);
            this.prepareHiveOutput();
        } else {
            LOG.warn((Object)"run: Warning - Output will be skipped!");
        }
        return cmdln;
    }

    private void addOptions(Options options) {
        options.addOption("h", "help", false, "Help");
        options.addOption("v", "verbose", false, "Verbose");
        options.addOption("D", "hiveconf", true, "property=value for Hive/Hadoop configuration");
        options.addOption("w", "workers", true, "Number of workers");
        if (this.computationClass == null) {
            options.addOption(null, "computationClass", true, "Giraph Computation class to use");
        }
        options.addOption("db", "dbName", true, "Hive database name");
        options.addOption("mi", "mappingInput", true, "Giraph " + HiveToMapping.class.getSimpleName() + " class to use, table name and " + "partition filter (optional). Example:\n" + "\"MyHiveToMapping, myTableName, a=1,b=two");
        options.addOption("vi", "vertexInput", true, HiveGiraphRunner.getInputOptionDescription("vertex", HiveToVertex.class.getSimpleName()));
        options.addOption("ei", "edgeInput", true, HiveGiraphRunner.getInputOptionDescription("edge", HiveToEdge.class.getSimpleName()));
        options.addOption("o", "output", true, "Giraph " + VertexToHive.class.getSimpleName() + " class to use," + " table name and partition filter (optional). Example:\n" + "\"MyVertexToHive, myTableName, a=1,b=two\"");
        options.addOption("s", "skipOutput", false, "Skip output?");
    }

    private static String getInputOptionDescription(String inputType, String hiveToObjectClassName) {
        StringBuilder inputOption = new StringBuilder();
        inputOption.append("Giraph ").append(hiveToObjectClassName).append(" class to use, table name and partition filter (optional).");
        inputOption.append(" Additional options for the input format can be specified as well.");
        inputOption.append(" You can set as many ").append(inputType).append(" inputs as you like.");
        inputOption.append(" Example:\n");
        inputOption.append("\"My").append(hiveToObjectClassName).append(", myTableName, a<2 AND b='two', option1=value1, option2=value2\"");
        return inputOption.toString();
    }

    private <T> Class<? extends T> findClass(String className, Class<T> base) {
        try {
            Class<?> cls = Class.forName(className);
            if (base.isAssignableFrom(cls)) {
                return cls.asSubclass(base);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(className + ": Invalid class name");
        }
    }

    public final Configuration getConf() {
        return this.conf;
    }

    public final void setConf(Configuration conf) {
        this.conf = new GiraphConfiguration(conf);
    }

    protected void addMoreOptions(Options options) {
    }

    protected void processMoreArguments(CommandLine cmd) {
    }

    protected void initGiraphJob(GiraphJob job) {
    }

    private void logOptions(GiraphConfiguration giraphConf) {
        LOG.info((Object)(this.getClass().getSimpleName() + " with"));
        LOG.info((Object)("\t-computationClass=" + this.computationClass.getCanonicalName()));
        for (VertexInputFormatDescription vertexInputFormatDescription : this.vertexInputDescriptions) {
            LOG.info((Object)("\tVertex input: " + vertexInputFormatDescription));
        }
        for (EdgeInputFormatDescription edgeInputFormatDescription : this.edgeInputDescriptions) {
            LOG.info((Object)("\tEdge input: " + edgeInputFormatDescription));
        }
        if (GiraphConstants.VERTEX_OUTPUT_FORMAT_CLASS.contains((Configuration)giraphConf)) {
            LOG.info((Object)("\tOutput: VertexToHive=" + this.vertexToHiveClass.getCanonicalName() + ", table=" + GiraphHiveConstants.HIVE_VERTEX_OUTPUT_TABLE.get(this.conf) + ", partition=\"" + GiraphHiveConstants.HIVE_VERTEX_OUTPUT_PARTITION.get(this.conf) + "\""));
        }
        LOG.info((Object)("\t-workers=" + this.workers));
    }

    private static String[] split(String stringToSplit, String separator) {
        return HiveGiraphRunner.split(stringToSplit, separator, -1);
    }

    private static String[] split(String stringToSplit, String separator, int limit) {
        Splitter splitter = Splitter.on((String)separator).trimResults();
        if (limit > 0) {
            splitter = splitter.limit(limit);
        }
        return (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)stringToSplit), String.class);
    }

    private static String elementOrNull(String[] array, int position) {
        return position < array.length ? array[position] : null;
    }

    private static String[] copyOfArray(String[] array, int startIndex) {
        if (array.length <= startIndex) {
            return new String[0];
        }
        return Arrays.copyOfRange(array, startIndex, array.length);
    }
}

