/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.table;

import com.facebook.hiveio.common.BackoffRetryTask;
import com.facebook.hiveio.common.Writables;
import com.facebook.hiveio.output.HiveOutputDescription;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.thrift.TException;

public class HiveTables {
    public static final String PROFILE_KEY_PREFIX = "hive.io.table.profile.";

    protected HiveTables() {
    }

    public static Table getTable(Configuration conf, String profile, HiveOutputDescription outputDesc) throws IOException {
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        Preconditions.checkNotNull((Object)profile, (Object)"profile is null");
        Preconditions.checkNotNull((Object)outputDesc, (Object)"outputDesc is null");
        Table table = HiveTables.getFromConf(conf, profile);
        if (table == null) {
            table = HiveTables.lookup(conf, outputDesc);
            HiveTables.putToConf(conf, profile, table);
        }
        return table;
    }

    public static Table getFromConf(Configuration conf, String profile) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        Preconditions.checkNotNull((Object)profile, (Object)"profile is null");
        String key = HiveTables.profileKey(profile);
        String value = conf.get(key);
        if (value == null) {
            return null;
        }
        return (Table)Writables.readObjectFromString(value);
    }

    public static void putToConf(Configuration conf, String profile, Table table) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        Preconditions.checkNotNull((Object)profile, (Object)"profile is null");
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        conf.set(HiveTables.profileKey(profile), Writables.writeObjectToString((Serializable)table));
    }

    private static Table lookup(final Configuration conf, final HiveOutputDescription outputDesc) throws IOException {
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        Preconditions.checkNotNull((Object)outputDesc, (Object)"outputDesc is null");
        BackoffRetryTask<Table> backoffRetryTask = new BackoffRetryTask<Table>(conf){

            @Override
            public Table idempotentTask() throws TException {
                String dbName = outputDesc.getTableDesc().getDatabaseName();
                String tableName = outputDesc.getTableDesc().getTableName();
                ThriftHiveMetastore.Iface client = outputDesc.metastoreClient(conf);
                return client.get_table(dbName, tableName);
            }
        };
        return (Table)backoffRetryTask.run();
    }

    private static String profileKey(String profile) {
        return PROFILE_KEY_PREFIX + profile;
    }
}

