/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.schema;

import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class TestSchema
implements HiveTableSchema {
    private final Map<String, Integer> nameToIndex = Maps.newHashMap();
    private final List<HiveType> types = Lists.newArrayList();
    private final HiveTableDesc tableDesc = new HiveTableDesc();
    private int numPartitions = 0;
    private int maxIndex = -1;

    @Override
    public HiveType columnType(int columnIndex) {
        return this.types.get(columnIndex);
    }

    @Override
    public HiveTableDesc getTableDesc() {
        return this.tableDesc;
    }

    @Override
    public int positionOf(String columnOrPartitionKeyName) {
        return this.nameToIndex.get(columnOrPartitionKeyName);
    }

    @Override
    public int numColumns() {
        return this.types.size();
    }

    @Override
    public int numPartitionKeys() {
        return this.numPartitions;
    }

    public void write(DataOutput out) throws IOException {
        throw new IllegalStateException();
    }

    public void readFields(DataInput in) throws IOException {
        throw new IllegalStateException();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TestSchema schema = new TestSchema();

        public Builder addColumn(String name, HiveType type) {
            return this.addColumn(name, this.schema.maxIndex + 1, type);
        }

        public Builder addColumn(String name, int index, HiveType type) {
            Preconditions.checkArgument((this.schema.types.size() <= index ? 1 : 0) != 0);
            while (this.schema.types.size() < index) {
                this.schema.types.add(null);
            }
            this.schema.types.add(type);
            this.schema.nameToIndex.put(name, index);
            this.schema.maxIndex = Math.max(this.schema.maxIndex, index);
            return this;
        }

        public Builder setNumPartitions(int numPartitions) {
            this.schema.numPartitions = numPartitions;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.schema.tableDesc.setTableName(tableName);
            return this;
        }

        public TestSchema build() {
            return this.schema;
        }
    }
}

