/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.schema;

import com.facebook.hiveio.common.BackoffRetryTask;
import com.facebook.hiveio.common.HiveMetastores;
import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.common.HiveUtils;
import com.facebook.hiveio.common.Writables;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.facebook.hiveio.schema.HiveTableSchemaAware;
import com.facebook.hiveio.schema.HiveTableSchemaImpl;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableSchemas {
    public static final String PROFILE_KEY_PREFIX = "hive.io.schema.profile.";
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableSchemas.class);

    protected HiveTableSchemas() {
    }

    public static void configure(Object obj, HiveTableSchema schema) {
        if (obj instanceof HiveTableSchemaAware) {
            ((HiveTableSchemaAware)obj).setTableSchema(schema);
        }
    }

    public static Function<String, Integer> schemaLookupFunc(final HiveTableSchema tableSchema) {
        return new Function<String, Integer>(){

            public Integer apply(String input) {
                return tableSchema.positionOf(input);
            }
        };
    }

    public static HiveTableSchema initTableSchema(Configuration conf, String profile, HiveTableDesc tableName) throws IOException {
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        Preconditions.checkNotNull((Object)profile, (Object)"profile is null");
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        HiveTableSchema hiveTableSchema = HiveTableSchemas.getFromConf(conf, profile);
        if (hiveTableSchema == null) {
            hiveTableSchema = HiveTableSchemas.lookup(conf, tableName);
            HiveTableSchemas.putToConf(conf, profile, hiveTableSchema);
        }
        return hiveTableSchema;
    }

    public static HiveTableSchema getFromConf(Configuration conf, String profile) {
        String key = HiveTableSchemas.profileKey(profile);
        String value = conf.get(key);
        if (value == null) {
            return null;
        }
        HiveTableSchemaImpl hiveTableSchema = new HiveTableSchemaImpl();
        Writables.readFieldsFromEncodedStr(value, hiveTableSchema);
        return hiveTableSchema;
    }

    public static void putToConf(Configuration conf, String profile, HiveTableSchema hiveTableSchema) {
        conf.set(HiveTableSchemas.profileKey(profile), Writables.writeToEncodedStr(hiveTableSchema));
    }

    public static HiveTableSchema lookup(Configuration conf, final HiveTableDesc tableName) throws IOException {
        final HiveConf hiveConf = HiveUtils.newHiveConf(conf, HiveTableSchemas.class);
        BackoffRetryTask<Table> backoffRetryTask = new BackoffRetryTask<Table>(conf){

            @Override
            public Table idempotentTask() throws TException {
                ThriftHiveMetastore.Iface client = HiveMetastores.create(hiveConf);
                return client.get_table(tableName.getDatabaseName(), tableName.getTableName());
            }
        };
        Table table = (Table)backoffRetryTask.run();
        return HiveTableSchemaImpl.fromTable(conf, table);
    }

    public static HiveTableSchema lookup(ThriftHiveMetastore.Iface client, Configuration conf, HiveTableDesc tableName) {
        Table table;
        try {
            table = client.get_table(tableName.getDatabaseName(), tableName.getTableName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return HiveTableSchemaImpl.fromTable(conf, table);
    }

    private static String profileKey(String profile) {
        return PROFILE_KEY_PREFIX + profile;
    }
}

