/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.schema;

import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.common.HiveUtils;
import com.facebook.hiveio.common.Writables;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveTableSchemaImpl
implements HiveTableSchema {
    private final HiveTableDesc tableName;
    private final Map<String, Integer> partitionPositions;
    private final Map<String, Integer> columnPositions;
    private HiveType[] hiveTypes;
    private int numColumns;
    private int numPartitionKeys;

    public HiveTableSchemaImpl() {
        this.tableName = new HiveTableDesc("_unknown_");
        this.partitionPositions = Maps.newHashMap();
        this.columnPositions = Maps.newHashMap();
        this.hiveTypes = new HiveType[0];
    }

    public HiveTableSchemaImpl(HiveTableDesc tableName, Map<String, Integer> partitionPositions, Map<String, Integer> columnPositions, HiveType[] hiveTypes) {
        this.tableName = tableName;
        this.partitionPositions = partitionPositions;
        this.columnPositions = columnPositions;
        this.hiveTypes = hiveTypes;
        this.numColumns = HiveTableSchemaImpl.sizeFromIndexes(columnPositions);
        this.numPartitionKeys = HiveTableSchemaImpl.sizeFromIndexes(partitionPositions);
    }

    public static HiveTableSchemaImpl fromTable(Configuration conf, Table table) {
        int index = 0;
        StorageDescriptor storageDescriptor = table.getSd();
        HiveType[] hiveTypes = HiveUtils.columnTypes(conf, storageDescriptor);
        List columnNames = Lists.transform((List)storageDescriptor.getCols(), HiveUtils.FIELD_SCHEMA_NAME_GETTER);
        HashMap columnToIndex = Maps.newHashMap();
        for (String columnName : columnNames) {
            columnToIndex.put(columnName, index++);
        }
        List partitionNames = Lists.transform((List)table.getPartitionKeys(), HiveUtils.FIELD_SCHEMA_NAME_GETTER);
        HashMap partitionToIndex = Maps.newHashMap();
        for (String partitionName : partitionNames) {
            partitionToIndex.put(partitionName, index++);
        }
        HiveTableDesc hiveTableDesc = new HiveTableDesc(table.getDbName(), table.getTableName());
        return new HiveTableSchemaImpl(hiveTableDesc, partitionToIndex, columnToIndex, hiveTypes);
    }

    private static int sizeFromIndexes(Map<String, Integer> columnPositions) {
        if (columnPositions.isEmpty()) {
            return 0;
        }
        return (Integer)Ordering.natural().max(columnPositions.values()) + 1;
    }

    @Override
    public HiveTableDesc getTableDesc() {
        return this.tableName;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numPartitionKeys() {
        return this.numPartitionKeys;
    }

    @Override
    public int positionOf(String columnOrPartitionKeyName) {
        Integer index = this.columnPositions.get(columnOrPartitionKeyName);
        if (index == null && (index = this.partitionPositions.get(columnOrPartitionKeyName)) == null) {
            throw new IllegalArgumentException("Column or partition " + columnOrPartitionKeyName + " not found in schema " + this);
        }
        return index;
    }

    @Override
    public HiveType columnType(int columnIndex) {
        Preconditions.checkElementIndex((int)columnIndex, (int)this.hiveTypes.length);
        return this.hiveTypes[columnIndex];
    }

    public void write(DataOutput out) throws IOException {
        Writables.writeStrIntMap(out, this.partitionPositions);
        Writables.writeStrIntMap(out, this.columnPositions);
        this.tableName.write(out);
        Writables.writeEnumArray(out, this.hiveTypes);
    }

    public void readFields(DataInput in) throws IOException {
        Writables.readStrIntMap(in, this.partitionPositions);
        Writables.readStrIntMap(in, this.columnPositions);
        this.numColumns = HiveTableSchemaImpl.sizeFromIndexes(this.columnPositions);
        this.tableName.readFields(in);
        this.hiveTypes = (HiveType[])Writables.readEnumArray((DataInput)in, HiveType.class);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("partitionKeys", this.partitionPositions).add("columnPositions", this.columnPositions).add("hiveTypes", (Object)this.hiveTypes).toString();
    }
}

