/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.output;

import com.facebook.hiveio.common.ProgressReporter;
import com.facebook.hiveio.output.HiveApiOutputFormat;
import com.facebook.hiveio.output.RecordWriterImpl;
import com.facebook.hiveio.record.HiveWritableRecord;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettableRecordWriterImpl
extends RecordWriterImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ResettableRecordWriterImpl.class);
    private final TaskAttemptContext taskAttemptContext;
    private final OutputFormat baseOutputFormat;
    private final long writeTimeoutMs;

    public ResettableRecordWriterImpl(RecordWriter<WritableComparable, Writable> baseWriter, Serializer serializer, ObjectInspector objectInspector, TaskAttemptContext taskAttemptContext, OutputFormat baseOutputFormat, long writeTimeoutMs) {
        super(baseWriter, serializer, objectInspector);
        this.taskAttemptContext = taskAttemptContext;
        this.baseOutputFormat = baseOutputFormat;
        this.writeTimeoutMs = writeTimeoutMs;
    }

    @Override
    public void write(WritableComparable key, HiveWritableRecord value) throws IOException, InterruptedException {
        long startTime = System.currentTimeMillis();
        super.write(key, value);
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (elapsedTime > this.writeTimeoutMs) {
            LOG.info("write: Write taking too long ({}s), creating new file to write to", (Object)elapsedTime);
            this.baseWriter.close((Reporter)new ProgressReporter((Progressable)this.taskAttemptContext));
            this.baseWriter = HiveApiOutputFormat.getBaseRecordWriter(this.taskAttemptContext, this.baseOutputFormat);
        }
    }
}

