/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.output;

import com.facebook.hiveio.common.ProgressReporter;
import com.facebook.hiveio.output.HiveApiOutputObserver;
import com.facebook.hiveio.record.HiveWritableRecord;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordWriterImpl
extends RecordWriter<WritableComparable, HiveWritableRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(RecordWriterImpl.class);
    protected org.apache.hadoop.mapred.RecordWriter<WritableComparable, Writable> baseWriter;
    private final Serializer serializer;
    private final ObjectInspector objectInspector;
    private HiveApiOutputObserver observer;

    public RecordWriterImpl(org.apache.hadoop.mapred.RecordWriter<WritableComparable, Writable> baseWriter, Serializer serializer, ObjectInspector objectInspector) {
        this.baseWriter = baseWriter;
        this.serializer = serializer;
        this.objectInspector = objectInspector;
        this.observer = HiveApiOutputObserver.Empty.get();
    }

    public HiveApiOutputObserver getObserver() {
        return this.observer;
    }

    public void setObserver(HiveApiOutputObserver observer) {
        if (observer != null) {
            this.observer = observer;
        }
    }

    public void write(WritableComparable key, HiveWritableRecord value) throws IOException, InterruptedException {
        Writable serializedValue = this.serialize(key, value);
        this.write(key, value, serializedValue);
    }

    private Writable serialize(WritableComparable key, HiveWritableRecord value) throws IOException {
        Writable serializedValue;
        List<Object> rowData = value.getAllColumns();
        this.observer.beginSerialize(key, value);
        try {
            serializedValue = this.serializer.serialize(rowData, this.objectInspector);
        }
        catch (SerDeException e) {
            this.observer.serializeFailed(key, value);
            throw new IOException("Serialize failed", e);
        }
        this.observer.endSerialize(key, value);
        return serializedValue;
    }

    private void write(WritableComparable key, HiveWritableRecord value, Writable serializedValue) throws IOException {
        this.observer.beginWrite(key, value);
        this.baseWriter.write((Object)NullWritable.get(), (Object)serializedValue);
        this.observer.endWrite(key, value);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.baseWriter.close((Reporter)new ProgressReporter((Progressable)context));
    }
}

