/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.output;

import com.facebook.hiveio.common.Classes;
import com.facebook.hiveio.common.SerDes;
import com.facebook.hiveio.common.Writables;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputInfo
implements Writable {
    private static final Logger LOG = LoggerFactory.getLogger(OutputInfo.class);
    private final Map<String, String> tableParams;
    private Class<? extends OutputFormat> outputFormatClass;
    private final List<FieldSchema> partitionInfo;
    private final List<FieldSchema> columnInfo;
    private Class<? extends SerDe> serializerClass;
    private final Map<String, String> serializerParams;
    private String tableRoot;
    private String partitionPath;
    private String finalOutputPath;

    public OutputInfo() {
        this.tableParams = Maps.newHashMap();
        this.partitionInfo = Lists.newArrayList();
        this.columnInfo = Lists.newArrayList();
        this.serializerClass = null;
        this.serializerParams = Maps.newHashMap();
    }

    public OutputInfo(Table table) {
        this.partitionInfo = table.getPartitionKeys();
        StorageDescriptor storageDescriptor = table.getSd();
        this.tableParams = table.getParameters();
        this.outputFormatClass = Classes.classForName(storageDescriptor.getOutputFormat());
        this.columnInfo = storageDescriptor.getCols();
        this.tableRoot = storageDescriptor.getLocation();
        SerDeInfo serDeInfo = storageDescriptor.getSerdeInfo();
        this.serializerClass = SerDes.getSerDeClass(serDeInfo);
        this.serializerParams = serDeInfo.getParameters();
    }

    public String getTableRoot() {
        return this.tableRoot;
    }

    public List<FieldSchema> getColumnInfo() {
        return this.columnInfo;
    }

    public Map<String, String> getTableParams() {
        return this.tableParams;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return this.outputFormatClass;
    }

    public Class<? extends Serializer> getSerializerClass() {
        return this.serializerClass;
    }

    public Map<String, String> getSerializerParams() {
        return this.serializerParams;
    }

    public List<FieldSchema> getPartitionInfo() {
        return this.partitionInfo;
    }

    public boolean hasPartitionInfo() {
        return this.partitionInfo != null && !this.partitionInfo.isEmpty();
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public OutputInfo setPartitionPath(String partitionPath) {
        LOG.info("Setting partition path to {}", (Object)partitionPath);
        this.partitionPath = partitionPath;
        return this;
    }

    public String getFinalOutputPath() {
        return this.finalOutputPath;
    }

    public OutputInfo setFinalOutputPath(String finalOutputPath) {
        LOG.info("Setting final output path to {}", (Object)finalOutputPath);
        this.finalOutputPath = finalOutputPath;
        return this;
    }

    public Serializer createSerializer(Configuration conf) {
        Serializer serializer = (Serializer)ReflectionUtils.newInstance(this.serializerClass, (Configuration)conf);
        SerDes.initSerializer(serializer, conf, this.columnInfo, this.serializerParams);
        return serializer;
    }

    public void write(DataOutput out) throws IOException {
        Writables.writeClassName(out, (Class)Preconditions.checkNotNull(this.outputFormatClass));
        Writables.writeFieldSchemas(out, this.partitionInfo);
        Writables.writeStrStrMap(out, this.tableParams);
        Writables.writeFieldSchemas(out, this.columnInfo);
        WritableUtils.writeString((DataOutput)out, (String)((String)Preconditions.checkNotNull((Object)this.tableRoot)));
        WritableUtils.writeString((DataOutput)out, (String)((String)Preconditions.checkNotNull((Object)this.partitionPath)));
        WritableUtils.writeString((DataOutput)out, (String)((String)Preconditions.checkNotNull((Object)this.finalOutputPath)));
        Writables.writeClassName(out, (Class)Preconditions.checkNotNull(this.serializerClass));
        Writables.writeStrStrMap(out, this.serializerParams);
    }

    public void readFields(DataInput in) throws IOException {
        this.outputFormatClass = Writables.readClass(in);
        Writables.readFieldSchemas(in, this.partitionInfo);
        Writables.readStrStrMap(in, this.tableParams);
        Writables.readFieldSchemas(in, this.columnInfo);
        this.tableRoot = WritableUtils.readString((DataInput)in);
        this.partitionPath = WritableUtils.readString((DataInput)in);
        this.finalOutputPath = WritableUtils.readString((DataInput)in);
        this.serializerClass = Writables.readClass(in);
        Writables.readStrStrMap(in, this.serializerParams);
    }
}

