/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.output;

import com.facebook.hiveio.common.Writables;
import com.facebook.hiveio.conf.BooleanConfOption;
import com.facebook.hiveio.conf.LongConfOption;
import com.facebook.hiveio.output.HiveOutputDescription;
import com.facebook.hiveio.output.OutputInfo;
import com.google.common.base.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;

public class OutputConf {
    public static final String PREFIX_KEY = "hive.io.output";
    public static final String OUTPUT_TABLE_INFO_KEY = "table_info";
    public static final String OUTPUT_DESCRIPTION_KEY = "description";
    public static final BooleanConfOption RESET_SLOW_WRITES = new BooleanConfOption("hive.io.output.reset_slow_writes", false);
    public static final LongConfOption WRITE_RESET_TIMEOUT = new LongConfOption("hive.io.output.write_reset_timeout", TimeUnit.SECONDS.toMillis(10L));
    public static final BooleanConfOption DROP_PARTITION_IF_EXISTS = new BooleanConfOption("hive.io.output.drop_partition", false);
    private final Configuration conf;
    private final String profileId;

    public OutputConf(Configuration conf, String profileId) {
        this.conf = conf;
        this.profileId = profileId;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getProfilePrefix() {
        return "hive.io.output." + this.profileId + ".";
    }

    public String getOutputTableInfoKey() {
        return this.getProfileId() + OUTPUT_TABLE_INFO_KEY;
    }

    public String getOutputDescriptionKey() {
        return this.getProfileId() + OUTPUT_DESCRIPTION_KEY;
    }

    public boolean shouldResetSlowWrites() {
        return RESET_SLOW_WRITES.get(this.conf);
    }

    public long getWriteResetTimeout() {
        return WRITE_RESET_TIMEOUT.get(this.conf);
    }

    public boolean shouldDropPartitionIfExists() {
        return DROP_PARTITION_IF_EXISTS.get(this.conf);
    }

    public OutputInfo readOutputTableInfo() {
        String value = this.conf.get(this.getOutputTableInfoKey());
        OutputInfo oti = null;
        if (value != null) {
            oti = new OutputInfo();
            Writables.readFieldsFromEncodedStr(value, oti);
        }
        return oti;
    }

    public void writeOutputTableInfo(OutputInfo oti) {
        this.conf.set(this.getOutputTableInfoKey(), Writables.writeToEncodedStr(oti));
    }

    public HiveOutputDescription readOutputDescription() {
        String value = this.conf.get(this.getOutputDescriptionKey());
        HiveOutputDescription hod = null;
        if (value != null) {
            hod = new HiveOutputDescription();
            Writables.readFieldsFromEncodedStr(value, hod);
        }
        return hod;
    }

    public void writeOutputDescription(HiveOutputDescription hod) {
        this.conf.set(this.getOutputDescriptionKey(), Writables.writeToEncodedStr(hod));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("profileId", (Object)this.profileId).toString();
    }
}

