/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.output;

import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.common.MetastoreDesc;
import com.facebook.hiveio.common.Writables;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.io.Writable;
import org.apache.thrift.TException;

public class HiveOutputDescription
implements Writable {
    private MetastoreDesc metastoreDesc = new MetastoreDesc();
    private HiveTableDesc tableDesc = new HiveTableDesc();
    private Map<String, String> partitionValues = Maps.newHashMap();

    public HiveTableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(HiveTableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    public int numPartitionValues() {
        return this.partitionValues.size();
    }

    public boolean hasPartitionValues() {
        return this.partitionValues != null && !this.partitionValues.isEmpty();
    }

    public HiveOutputDescription setPartitionValues(Map<String, String> partitionValues) {
        this.partitionValues = partitionValues;
        return this;
    }

    public HiveOutputDescription putPartitionValue(String key, String value) {
        this.partitionValues.put(key, value);
        return this;
    }

    public MetastoreDesc getMetastoreDesc() {
        return this.metastoreDesc;
    }

    public ThriftHiveMetastore.Iface metastoreClient(Configuration conf) throws TException {
        return this.metastoreDesc.makeClient(conf);
    }

    public void write(DataOutput out) throws IOException {
        this.metastoreDesc.write(out);
        this.tableDesc.write(out);
        Writables.writeStrStrMap(out, this.partitionValues);
    }

    public void readFields(DataInput in) throws IOException {
        this.metastoreDesc.readFields(in);
        this.tableDesc.readFields(in);
        Writables.readStrStrMap(in, this.partitionValues);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("metastoreDesc", (Object)this.metastoreDesc).add("tableDesc", (Object)this.tableDesc).add("partitionValues", this.partitionValues).toString();
    }
}

